/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.framework.core.model.AbstractOseeIdType;
import org.eclipse.osee.framework.core.model.OseeEnumEntry;
import org.eclipse.osee.framework.core.model.internal.fields.EnumEntryField;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public class OseeEnumType
extends AbstractOseeIdType {
    public static final String OSEE_ENUM_TYPE_ENTRIES_FIELD = "osee.enum.type.entries.field";
    private final Collection<OseeEnumEntry> enumEntries = new HashSet<OseeEnumEntry>();

    public OseeEnumType(Long guid, String enumTypeName) {
        super(guid, enumTypeName);
        this.addField(OSEE_ENUM_TYPE_ENTRIES_FIELD, new EnumEntryField(this.enumEntries));
    }

    public String toString() {
        ArrayList<String> data = new ArrayList<String>();
        try {
            OseeEnumEntry[] oseeEnumEntryArray = this.values();
            int n = oseeEnumEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                OseeEnumEntry entry = oseeEnumEntryArray[n2];
                data.add(entry.toString());
                ++n2;
            }
        }
        catch (OseeCoreException oseeCoreException) {
            data.add("Error");
        }
        return String.format("[%s] - %s", this.getName(), data);
    }

    public OseeEnumEntry[] values() throws OseeCoreException {
        Collection values = (Collection)this.getFieldValue(OSEE_ENUM_TYPE_ENTRIES_FIELD);
        ArrayList entries = new ArrayList(values);
        Collections.sort(entries);
        return entries.toArray(new OseeEnumEntry[entries.size()]);
    }

    public OseeEnumEntry getEntryByName(String entryName) throws OseeCoreException {
        Collection values = (Collection)this.getFieldValue(OSEE_ENUM_TYPE_ENTRIES_FIELD);
        for (OseeEnumEntry entry : values) {
            if (!entry.getName().equals(entryName)) continue;
            return entry;
        }
        return null;
    }

    public Set<String> valuesAsOrderedStringSet() throws OseeCoreException {
        LinkedHashSet<String> values = new LinkedHashSet<String>();
        OseeEnumEntry[] oseeEnumEntryArray = this.values();
        int n = oseeEnumEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            OseeEnumEntry oseeEnumEntry = oseeEnumEntryArray[n2];
            values.add(oseeEnumEntry.getName());
            ++n2;
        }
        return values;
    }

    public OseeEnumEntry valueOf(int ordinal) throws OseeCoreException {
        OseeEnumEntry toReturn = null;
        OseeEnumEntry[] oseeEnumEntryArray = this.values();
        int n = oseeEnumEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            OseeEnumEntry oseeEnumEntry = oseeEnumEntryArray[n2];
            if (oseeEnumEntry.ordinal() == ordinal) {
                toReturn = oseeEnumEntry;
            }
            ++n2;
        }
        if (toReturn == null) {
            throw new OseeArgumentException("No enum const [%s] - ordinal [%s]", new Object[]{this.getName(), ordinal});
        }
        return toReturn;
    }

    public OseeEnumEntry valueOf(String entryName) throws OseeCoreException {
        OseeEnumEntry toReturn = null;
        OseeEnumEntry[] oseeEnumEntryArray = this.values();
        int n = oseeEnumEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            OseeEnumEntry oseeEnumEntry = oseeEnumEntryArray[n2];
            if (oseeEnumEntry.getName().equals(entryName)) {
                toReturn = oseeEnumEntry;
            }
            ++n2;
        }
        if (toReturn == null) {
            throw new OseeArgumentException("No enum const [%s].[%s]", new Object[]{this.getName(), entryName});
        }
        return toReturn;
    }

    public void setEntries(List<OseeEnumEntry> entries) throws OseeCoreException {
        this.setField(OSEE_ENUM_TYPE_ENTRIES_FIELD, entries);
    }

    public void addEntry(OseeEnumEntry entry) throws OseeCoreException {
        ArrayList<OseeEnumEntry> entries = new ArrayList<OseeEnumEntry>();
        entries.addAll(Arrays.asList(this.values()));
        entries.add(entry);
        this.setEntries(entries);
    }

    public void removeEntry(OseeEnumEntry entry) throws OseeCoreException {
        ArrayList<OseeEnumEntry> entries = new ArrayList<OseeEnumEntry>();
        entries.addAll(Arrays.asList(this.values()));
        if (!entries.remove(entry)) {
            throw new OseeArgumentException("OseeEnumEntry[%s] does not exist on OseeEnumType[%s]", new Object[]{entry, this});
        }
        this.setEntries(entries);
    }
}

