/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model.type;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.model.AbstractOseeIdType;
import org.eclipse.osee.framework.core.model.Branch;
import org.eclipse.osee.framework.core.model.IOseeField;
import org.eclipse.osee.framework.core.model.OseeField;
import org.eclipse.osee.framework.core.model.internal.fields.ArtifactSuperTypeField;
import org.eclipse.osee.framework.core.model.internal.fields.ArtifactTypeAttributesField;
import org.eclipse.osee.framework.core.model.type.AttributeType;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public class ArtifactType
extends AbstractOseeIdType
implements IArtifactType {
    public static final String ARTIFACT_IS_ABSTRACT_FIELD_KEY = "osee.artifact.type.is.abstract.field";
    public static final String ARTIFACT_INHERITANCE_FIELD_KEY = "osee.artifact.type.inheritance.field";
    public static final String ARTIFACT_TYPE_ATTRIBUTES_FIELD_KEY = "osee.artifact.type.attributes.field";
    private final Set<ArtifactType> superTypes = new HashSet<ArtifactType>();
    private final Set<ArtifactType> childTypes = new HashSet<ArtifactType>();
    private final Map<BranchId, Collection<AttributeType>> attributes = new HashMap<BranchId, Collection<AttributeType>>();

    public ArtifactType(Long guid, String name, boolean isAbstract) {
        super(guid, name);
        this.initializeFields();
        this.setAbstract(isAbstract);
    }

    protected void initializeFields() {
        this.addField(ARTIFACT_IS_ABSTRACT_FIELD_KEY, new OseeField());
        this.addField(ARTIFACT_INHERITANCE_FIELD_KEY, new ArtifactSuperTypeField(this, this.superTypes));
        this.addField(ARTIFACT_TYPE_ATTRIBUTES_FIELD_KEY, new ArtifactTypeAttributesField(this.attributes));
    }

    public boolean hasSuperArtifactTypes() {
        Collection<ArtifactType> superTypes = this.getSuperArtifactTypes();
        return superTypes != null && !superTypes.isEmpty();
    }

    public Collection<ArtifactType> getSuperArtifactTypes() {
        List defaultValue = Collections.emptyList();
        return this.getFieldValueLogException(defaultValue, ARTIFACT_INHERITANCE_FIELD_KEY);
    }

    public void setSuperTypes(Set<ArtifactType> superType) throws OseeCoreException {
        HashSet<ArtifactType> originals = new HashSet<ArtifactType>(this.superTypes);
        this.setField(ARTIFACT_INHERITANCE_FIELD_KEY, superType);
        for (ArtifactType supers : superType) {
            supers.childTypes.add(this);
        }
        for (ArtifactType oldValue : originals) {
            if (superType.contains(oldValue)) continue;
            oldValue.childTypes.remove(this);
        }
    }

    public Collection<ArtifactType> getFirstLevelDescendantTypes() throws OseeCoreException {
        return this.getDescendants(this, false);
    }

    public Collection<ArtifactType> getAllDescendantTypes() throws OseeCoreException {
        return this.getDescendants(this, true);
    }

    private Collection<ArtifactType> getDescendants(ArtifactType artifactType, boolean isRecursionAllowed) throws OseeCoreException {
        HashSet<ArtifactType> descendants = new HashSet<ArtifactType>();
        this.populateDescendants(artifactType, descendants, isRecursionAllowed);
        return descendants;
    }

    private void populateDescendants(ArtifactType artifactType, Collection<ArtifactType> descendants, boolean isRecursionAllowed) throws OseeCoreException {
        for (ArtifactType type : artifactType.childTypes) {
            if (isRecursionAllowed) {
                this.populateDescendants(type, descendants, isRecursionAllowed);
            }
            descendants.add(type);
        }
    }

    public void setAttributeTypes(Collection<AttributeType> attributeTypes, BranchId branch) throws OseeCoreException {
        IOseeField field = this.getField(ARTIFACT_TYPE_ATTRIBUTES_FIELD_KEY);
        ((ArtifactTypeAttributesField)field).put(branch, attributeTypes);
    }

    public void setAllAttributeTypes(Map<BranchId, Collection<AttributeType>> attributeTypes) throws OseeCoreException {
        IOseeField field = this.getField(ARTIFACT_TYPE_ATTRIBUTES_FIELD_KEY);
        ((ArtifactTypeAttributesField)field).set(attributeTypes);
    }

    public boolean isValidAttributeType(AttributeTypeId attributeType, Branch branch) throws OseeCoreException {
        return this.getAttributeTypes(branch).contains(attributeType);
    }

    public Map<BranchId, Collection<AttributeType>> getLocalAttributeTypes() throws OseeCoreException {
        return (Map)this.getFieldValue(ARTIFACT_TYPE_ATTRIBUTES_FIELD_KEY);
    }

    public Collection<AttributeTypeToken> getAttributeTypes(Branch branch) throws OseeCoreException {
        HashSet<AttributeTypeToken> attributeTypes = new HashSet<AttributeTypeToken>();
        ArtifactType.getAttributeTypes(attributeTypes, this, branch);
        return attributeTypes;
    }

    private static void getAttributeTypes(Set<AttributeTypeToken> attributeTypes, ArtifactType artifactType, Branch branch) throws OseeCoreException {
        Map<BranchId, Collection<AttributeType>> validityMap = artifactType.getLocalAttributeTypes();
        if (!validityMap.isEmpty()) {
            for (BranchId ancestor : branch.getAncestors()) {
                Collection<AttributeType> items = validityMap.get(ancestor);
                if (items == null) continue;
                attributeTypes.addAll(items);
            }
        }
        for (ArtifactType superType : artifactType.getSuperArtifactTypes()) {
            ArtifactType.getAttributeTypes(attributeTypes, superType, branch);
        }
    }

    public boolean isAbstract() {
        return this.getFieldValueLogException(false, ARTIFACT_IS_ABSTRACT_FIELD_KEY);
    }

    public void setAbstract(boolean isAbstract) {
        this.setFieldLogException(ARTIFACT_IS_ABSTRACT_FIELD_KEY, isAbstract);
    }

    public boolean inheritsFrom(ArtifactTypeId ... otherTypes) {
        boolean result = false;
        ArtifactTypeId[] artifactTypeIdArray = otherTypes;
        int n = otherTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ArtifactTypeId otherArtifactType = artifactTypeIdArray[n2];
            if (this.inheritsFromSingle(otherArtifactType)) {
                result = true;
                break;
            }
            ++n2;
        }
        return result;
    }

    private boolean inheritsFromSingle(ArtifactTypeId otherType) {
        boolean result = false;
        if (this.equals(otherType)) {
            result = true;
        } else {
            for (ArtifactType superType : this.getSuperArtifactTypes()) {
                if (!superType.inheritsFrom(otherType)) continue;
                result = true;
                break;
            }
        }
        return result;
    }
}

