/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model.event;

import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.HasBranch;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.jdk.core.type.BaseIdentity;
import org.eclipse.osee.framework.jdk.core.util.GUID;

public class DefaultBasicGuidArtifact
extends BaseIdentity<String>
implements HasBranch {
    private final BranchId branch;
    private ArtifactTypeId artifactType;

    public DefaultBasicGuidArtifact(BranchId branch, ArtifactTypeId artifactType, String artGuid) {
        super((Object)artGuid);
        this.branch = branch;
        this.artifactType = artifactType;
    }

    public DefaultBasicGuidArtifact(BranchId branch, ArtifactTypeId artifactType) {
        this(branch, artifactType, GUID.create());
    }

    public DefaultBasicGuidArtifact(BranchId branch, ArtifactTypeId artifactType, ArtifactId artifact) {
        this(branch, artifactType, (String)artifact.getGuid());
    }

    public BranchId getBranch() {
        return this.branch;
    }

    public Long getArtTypeGuid() {
        return this.artifactType.getId();
    }

    public ArtifactTypeId getArtifactType() {
        return this.artifactType;
    }

    public String toString() {
        return String.format("branchId = %s; artType = %s; guid = %s", this.branch.getId(), this.artifactType.getId(), this.getGuid());
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        boolean equals = super.equals(obj);
        if (!equals && obj instanceof DefaultBasicGuidArtifact) {
            DefaultBasicGuidArtifact other = (DefaultBasicGuidArtifact)((Object)obj);
            if (this.artifactType == null || other.getArtTypeGuid() == null) {
                equals = false;
            }
            equals = this.artifactType.equals(other.getArtTypeGuid());
            if ((equals &= this.isOnSameBranch(other)) && this.getGuid() == null || other.getGuid() == null) {
                equals = false;
            } else if (equals) {
                equals = ((String)this.getGuid()).equals(other.getGuid());
            }
        }
        return equals;
    }

    public void setArtTypeGuid(ArtifactTypeId artifactType) {
        this.artifactType = artifactType;
    }

    public boolean is(IArtifactType ... artifactTypes) {
        IArtifactType[] iArtifactTypeArray = artifactTypes;
        int n = artifactTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactType artifactType = iArtifactTypeArray[n2];
            if (artifactType.getGuid().equals(this.getArtTypeGuid())) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

