/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model.change;

import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.model.change.ChangeIgnoreType;
import org.eclipse.osee.framework.core.model.change.ChangeType;
import org.eclipse.osee.framework.core.model.change.ChangeVersion;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public class ChangeItem
implements Comparable<ChangeItem> {
    private ChangeIgnoreType ignoreType = ChangeIgnoreType.SENTINEL;
    private ChangeType changeType = ChangeType.UNKNOWN_CHANGE;
    private ArtifactId artId = ArtifactId.SENTINEL;
    private Id itemId = Id.valueOf((long)Id.SENTINEL);
    private Id itemTypeId = Id.valueOf((long)Id.SENTINEL);
    private ChangeVersion baselineVersion = new ChangeVersion();
    private ChangeVersion firstNonCurrentChange = new ChangeVersion();
    private ChangeVersion currentVersion = new ChangeVersion();
    private ChangeVersion destinationVersion = new ChangeVersion();
    private ChangeVersion netChange = new ChangeVersion();
    private boolean synthetic = false;
    private boolean isApplicabilityCopy = false;
    private ArtifactId artIdB = ArtifactId.valueOf((long)-1L);

    public void copy(ChangeItem source) {
        Conditions.checkNotNull((Object)source, (String)"ChangeItem");
        this.setIgnoreType(source.getIgnoreType());
        this.setChangeType(source.getChangeType());
        this.setArtId(source.getArtId());
        this.setItemId(source.getItemId());
        this.setItemTypeId(source.getItemTypeId());
        this.setBaselineVersion(source.getBaselineVersion());
        this.setFirstNonCurrentChange(source.getFirstNonCurrentChange());
        this.setCurrentVersion(source.getCurrentVersion());
        this.setDestinationVersion(source.getDestinationVersion());
        this.setNetChange(source.getNetChange());
        this.setSynthetic(source.isSynthetic());
        this.setApplicabilityCopy(source.isApplicabilityCopy());
        this.setArtIdB(source.getArtIdB());
    }

    public ChangeIgnoreType getIgnoreType() {
        return this.ignoreType;
    }

    public void setIgnoreType(ChangeIgnoreType type) {
        this.ignoreType = type;
    }

    public void setSynthetic(boolean synthetic) {
        this.synthetic = synthetic;
    }

    public boolean isApplicabilityCopy() {
        return this.isApplicabilityCopy;
    }

    public void setApplicabilityCopy(boolean isApplicabilityCopy) {
        this.isApplicabilityCopy = isApplicabilityCopy;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public void setChangeType(ChangeType changeType) {
        this.changeType = changeType;
    }

    public void setArtId(ArtifactId artId) {
        this.artId = artId;
    }

    public void setItemId(Id itemId) {
        this.itemId = itemId;
    }

    public void setItemTypeId(Id itemTypeId) {
        this.itemTypeId = itemTypeId;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public ArtifactId getArtId() {
        return this.artId;
    }

    public Id getItemId() {
        return this.itemId;
    }

    public Id getItemTypeId() {
        return this.itemTypeId;
    }

    public ChangeVersion getBaselineVersion() {
        return this.baselineVersion;
    }

    public ChangeVersion getFirstNonCurrentChange() {
        return this.firstNonCurrentChange;
    }

    public ChangeVersion getCurrentVersion() {
        return this.currentVersion;
    }

    public ChangeVersion getDestinationVersion() {
        return this.destinationVersion;
    }

    public ChangeVersion getNetChange() {
        return this.netChange;
    }

    public void setBaselineVersion(ChangeVersion baselineVersion) {
        this.baselineVersion = baselineVersion;
    }

    public void setFirstNonCurrentChange(ChangeVersion firstNonCurrentChange) {
        this.firstNonCurrentChange = firstNonCurrentChange;
    }

    public void setCurrentVersion(ChangeVersion currentVersion) {
        this.currentVersion = currentVersion;
    }

    public void setDestinationVersion(ChangeVersion destinationVersion) {
        this.destinationVersion = destinationVersion;
    }

    public void setNetChange(ChangeVersion netChange) {
        this.netChange = netChange;
    }

    public ArtifactId getArtIdB() {
        return this.artIdB;
    }

    public void setArtIdB(ArtifactId artIdB) {
        this.artIdB = artIdB;
    }

    public String toString() {
        return String.format("ChangeItem - itemId:[%s] artId:%s typeId:%s base:%s first:%s current:%s destination:%s net:%s synthetic:%s ignoreType:%s", this.itemId, this.getArtId(), this.getItemTypeId(), this.getBaselineVersion(), this.getFirstNonCurrentChange(), this.getCurrentVersion(), this.getDestinationVersion(), this.getNetChange(), this.isSynthetic(), this.getIgnoreType().toString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ChangeItem)) {
            return false;
        }
        ChangeItem other = (ChangeItem)obj;
        if (!this.itemId.equals(other.itemId)) {
            return false;
        }
        if (!this.artId.equals(other.artId)) {
            return false;
        }
        if (this.currentVersion == null && other.currentVersion != null) {
            return false;
        }
        if (!this.currentVersion.equals(other.currentVersion)) {
            return false;
        }
        return this.itemTypeId.equals(other.itemTypeId);
    }

    public boolean totalEquals(ChangeItem other) {
        if (!this.equals(other)) {
            return false;
        }
        if (!this.ignoreType.equals((Object)other.ignoreType)) {
            return false;
        }
        if (!this.changeType.equals((Object)other.changeType)) {
            return false;
        }
        if (this.synthetic != other.synthetic) {
            return false;
        }
        if (this.isApplicabilityCopy != other.isApplicabilityCopy) {
            return false;
        }
        if (this.getArtIdB() != other.getArtIdB()) {
            return false;
        }
        if (this.baselineVersion == null && other.baselineVersion != null) {
            return false;
        }
        if (!this.baselineVersion.equals(other.baselineVersion)) {
            return false;
        }
        if (this.destinationVersion == null && other.destinationVersion != null) {
            return false;
        }
        if (!this.destinationVersion.equals(other.destinationVersion)) {
            return false;
        }
        if (this.netChange == null && other.netChange != null) {
            return false;
        }
        if (!this.netChange.equals(other.netChange)) {
            return false;
        }
        if (this.firstNonCurrentChange == null && other.firstNonCurrentChange != null) {
            return false;
        }
        return this.firstNonCurrentChange.equals(other.firstNonCurrentChange);
    }

    @Override
    public int compareTo(ChangeItem obj) {
        return this.itemId.getId().compareTo(obj.itemId.getId());
    }

    public int hashCode() {
        return this.itemId.getId().hashCode();
    }
}

