/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model.cache;

import java.util.function.Predicate;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.enums.BranchArchivedState;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.model.Branch;

public class BranchFilter
implements Predicate<Branch> {
    private final BranchArchivedState archivedState;
    private final BranchType[] branchTypes;
    private ArtifactToken associatedArtifact;
    private BranchState[] branchStates;
    private BranchState[] negatedBranchStates;
    private BranchType[] negatedBranchTypes;

    public BranchFilter(BranchArchivedState archivedState, BranchType ... branchTypes) {
        this.archivedState = archivedState;
        this.branchTypes = branchTypes;
    }

    public BranchFilter(BranchType ... branchTypes) {
        this(BranchArchivedState.ALL, branchTypes);
    }

    @Override
    public boolean test(Branch branch) {
        if (this.associatedArtifact != null && !branch.getAssociatedArtifactId().equals(this.associatedArtifact)) {
            return false;
        }
        if (!BranchArchivedState.fromBoolean((boolean)branch.isArchived()).matches(this.archivedState)) {
            return false;
        }
        if (this.branchTypes.length > 0 && !branch.getBranchType().isOfType(this.branchTypes)) {
            return false;
        }
        if (this.branchStates != null && !branch.getBranchState().matches(this.branchStates)) {
            return false;
        }
        if (this.negatedBranchStates != null && branch.getBranchState().matches(this.negatedBranchStates)) {
            return false;
        }
        return this.negatedBranchTypes == null || !branch.getBranchType().isOfType(this.negatedBranchTypes);
    }

    public void setAssociatedArtifact(ArtifactToken associatedArtifact) {
        this.associatedArtifact = associatedArtifact;
    }

    public void setBranchStates(BranchState ... branchStates) {
        this.branchStates = branchStates;
    }

    public void setNegatedBranchStates(BranchState ... negatedBranchStates) {
        this.negatedBranchStates = negatedBranchStates;
    }

    public void setNegatedBranchTypes(BranchType ... negatedBranchTypes) {
        this.negatedBranchTypes = negatedBranchTypes;
    }
}

