/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.OseeCacheEnum;
import org.eclipse.osee.framework.core.exception.OseeNotFoundException;
import org.eclipse.osee.framework.core.model.Branch;
import org.eclipse.osee.framework.core.model.MergeBranch;
import org.eclipse.osee.framework.core.model.cache.AbstractOseeLoadingCache;
import org.eclipse.osee.framework.core.model.cache.IOseeDataAccessor;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public class BranchCache
extends AbstractOseeLoadingCache<Branch> {
    private final List<Branch> views = new ArrayList<Branch>();

    public BranchCache(IOseeDataAccessor<Branch> dataAccessor) {
        super(OseeCacheEnum.BRANCH_CACHE, dataAccessor);
    }

    public MergeBranch findMergeBranch(BranchId sourceBranch, BranchId destinationBranch) throws OseeCoreException {
        Conditions.checkNotNull((Object)sourceBranch, (String)"source branch");
        Conditions.checkNotNull((Object)destinationBranch, (String)"destination branch");
        MergeBranch toReturn = null;
        for (Branch branch : this.getAll()) {
            MergeBranch mergeBranch;
            if (!(branch instanceof MergeBranch) || !sourceBranch.equals((mergeBranch = (MergeBranch)branch).getSourceBranch()) || !destinationBranch.equals(mergeBranch.getDestinationBranch())) continue;
            toReturn = mergeBranch;
            break;
        }
        return toReturn;
    }

    public MergeBranch findFirstMergeBranch(BranchId sourceBranch) throws OseeNotFoundException {
        Conditions.checkNotNull((Object)sourceBranch, (String)"source branch");
        for (Branch branch : this.getAll()) {
            MergeBranch mergeBranch;
            if (!(branch instanceof MergeBranch) || !sourceBranch.equals((mergeBranch = (MergeBranch)branch).getSourceBranch())) continue;
            return mergeBranch;
        }
        throw new OseeNotFoundException("Merge branch not found for source [%s]", new Object[]{sourceBranch});
    }

    public List<MergeBranch> findAllMergeBranches(BranchId sourceBranch) throws OseeCoreException {
        Conditions.checkNotNull((Object)sourceBranch, (String)"source branch");
        ArrayList<MergeBranch> toReturn = new ArrayList<MergeBranch>();
        for (Branch branch : this.getAll()) {
            MergeBranch mergeBranch;
            if (!(branch instanceof MergeBranch) || !sourceBranch.equals((mergeBranch = (MergeBranch)branch).getSourceBranch())) continue;
            toReturn.add(mergeBranch);
        }
        return toReturn;
    }

    public void setBranchViews(List<Branch> views) {
        this.views.clear();
        this.views.addAll(views);
    }

    public List<Branch> getViews() {
        return this.views;
    }

    public synchronized List<Branch> getBranchesAndViews(Predicate<Branch> branchFilter) {
        List<Branch> branches = this.getBranches(branchFilter);
        branches.addAll(this.views);
        return branches;
    }

    public synchronized List<Branch> getBranches(Predicate<Branch> branchFilter) {
        return this.getRawValues().stream().filter(branchFilter).collect(Collectors.toList());
    }

    public Branch get(BranchId branch) {
        return (Branch)((Object)this.getById(branch.getId()));
    }
}

