/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.osee.framework.core.enums.OseeCacheEnum;
import org.eclipse.osee.framework.core.model.cache.IOseeCache;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public abstract class AbstractOseeCache<T extends NamedIdBase>
implements IOseeCache<T> {
    private final HashCollection<String, T> nameToTypeMap = new HashCollection(true, CopyOnWriteArrayList.class);
    private final ConcurrentHashMap<Long, T> idToTypeMap = new ConcurrentHashMap();
    private final OseeCacheEnum cacheId;

    protected AbstractOseeCache(OseeCacheEnum cacheId) {
        this.cacheId = cacheId;
    }

    @Override
    public synchronized void decacheAll() {
        this.nameToTypeMap.clear();
        this.idToTypeMap.clear();
    }

    @Override
    public OseeCacheEnum getCacheId() {
        return this.cacheId;
    }

    @Override
    public int size() {
        return this.idToTypeMap.size();
    }

    public boolean existsByGuid(Long id) throws OseeCoreException {
        this.ensurePopulated();
        return this.idToTypeMap.containsKey(id);
    }

    @Override
    public void decache(T ... types) throws OseeCoreException {
        Conditions.checkNotNull(types, (String)"types to de-cache");
        T[] TArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            T type = TArray[n2];
            this.decache(type);
            ++n2;
        }
    }

    @Override
    public void decache(T type) throws OseeCoreException {
        Conditions.checkNotNull(type, (String)"type to de-cache");
        this.ensurePopulated();
        this.decacheByName(type);
        if (type.isValid()) {
            this.idToTypeMap.remove(type.getId());
        }
    }

    protected synchronized Collection<T> getRawValues() throws OseeCoreException {
        this.ensurePopulated();
        return this.idToTypeMap.values();
    }

    private void decacheByName(T type) {
        HashSet<String> keysToRemove = new HashSet<String>();
        for (String name : this.nameToTypeMap.keySet()) {
            Collection items = this.nameToTypeMap.getValues((Object)name);
            if (items == null || !items.contains(type)) continue;
            keysToRemove.add(name);
        }
        for (String key : keysToRemove) {
            this.nameToTypeMap.removeValue((Object)key, type);
        }
    }

    @Override
    public void cache(T ... types) throws OseeCoreException {
        Conditions.checkNotNull(types, (String)"types to cache");
        T[] TArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            T type = TArray[n2];
            this.cache(type);
            ++n2;
        }
    }

    @Override
    public void cache(T type) throws OseeCoreException {
        Conditions.checkNotNull(type, (String)"type to cache");
        this.ensurePopulated();
        this.nameToTypeMap.put((Object)type.getName(), type);
        this.idToTypeMap.putIfAbsent(type.getId(), type);
    }

    @Override
    public Collection<T> getAll() throws OseeCoreException {
        this.ensurePopulated();
        return new ArrayList<T>(this.idToTypeMap.values());
    }

    @Override
    public T getById(Number typeId) throws OseeCoreException {
        this.ensurePopulated();
        return (T)((NamedIdBase)this.idToTypeMap.get(typeId.longValue()));
    }

    public T getUniqueByName(String typeName) throws OseeCoreException {
        this.ensurePopulated();
        Collection<T> values = this.getByName(typeName);
        if (values.size() > 1) {
            throw new OseeStateException("Multiple items matching [%s] name exist", new Object[]{typeName});
        }
        return (T)(values.isEmpty() ? null : (NamedIdBase)values.iterator().next());
    }

    public Collection<T> getByName(String typeName) throws OseeCoreException {
        this.ensurePopulated();
        ArrayList types = new ArrayList();
        Collection values = this.nameToTypeMap.getValues((Object)typeName);
        if (values != null) {
            types.addAll(values);
        }
        return types;
    }

    public T getBySoleName(String typeName) throws OseeCoreException {
        this.ensurePopulated();
        Collection<T> types = this.getByName(typeName);
        if (types.size() != 1) {
            throw new OseeArgumentException("AbstractOseeCache expected 1 type but found [%d] types for [%s]", new Object[]{types.size(), typeName});
        }
        return (T)((NamedIdBase)types.iterator().next());
    }

    @Override
    public T getByGuid(Long id) throws OseeCoreException {
        this.ensurePopulated();
        return (T)((NamedIdBase)this.idToTypeMap.get(id));
    }

    public T get(Id token) throws OseeCoreException {
        this.ensurePopulated();
        return this.getByGuid(token.getId());
    }

    public void cacheFrom(AbstractOseeCache<T> source) throws OseeCoreException {
        for (NamedIdBase type : source.getAll()) {
            this.cache((T)type);
        }
    }

    protected void ensurePopulated() throws OseeCoreException {
    }
}

