/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model.access;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.framework.core.model.access.AccessData;
import org.eclipse.osee.framework.core.model.access.AccessDetail;
import org.eclipse.osee.framework.core.model.access.PermissionStatus;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public class AccessDataQuery {
    private final AccessData accessData;

    public AccessDataQuery(AccessData accessData) {
        this.accessData = accessData;
    }

    public String toString() {
        return this.accessData.toString();
    }

    public void branchMatches(PermissionEnum permissionToMatch, BranchId branchToMatch, PermissionStatus permissionStatus) throws OseeCoreException {
        Collection<AccessDetail<?>> branchAccessDetails = this.accessData.getAccess(branchToMatch);
        this.setTypePermissionStatus(permissionStatus, permissionToMatch, branchAccessDetails, branchToMatch);
    }

    public void branchArtifactTypeMatches(PermissionEnum permissionToMatch, BranchId branchToMatch, ArtifactTypeId artifactType, PermissionStatus permissionStatus) throws OseeCoreException {
        this.branchMatches(permissionToMatch, branchToMatch, permissionStatus);
        if (permissionStatus.matched()) {
            Collection<AccessDetail<?>> branchAccessDetails = this.accessData.getAccess(branchToMatch);
            this.setTypePermissionStatus(permissionStatus, permissionToMatch, branchAccessDetails, artifactType);
        }
    }

    public void artifactTypeMatches(PermissionEnum permissionToMatch, ArtifactToken artifact, PermissionStatus permissionStatus) throws OseeCoreException {
        IArtifactType typeToMatch = artifact.getArtifactType();
        BranchId branchToMatch = artifact.getBranch();
        this.branchArtifactTypeMatches(permissionToMatch, branchToMatch, (ArtifactTypeId)typeToMatch, permissionStatus);
        if (permissionStatus.matched()) {
            Collection<AccessDetail<?>> artifactAccessDetails = this.accessData.getAccess(artifact);
            this.setTypePermissionStatus(permissionStatus, permissionToMatch, artifactAccessDetails, artifact);
        }
    }

    public void artifactMatches(PermissionEnum permissionToMatch, final ArtifactToken artifact, PermissionStatus permissionStatus) throws OseeCoreException {
        BranchId branchToMatch = artifact.getBranch();
        this.branchMatches(permissionToMatch, branchToMatch, permissionStatus);
        if (permissionStatus.matched()) {
            Collection<AccessDetail<?>> mainList = this.accessData.getAccess(artifact);
            AccessDetail<?> mostSpecific = this.getNetAccess(mainList, new AccessFilter(){

                @Override
                public boolean accept(AccessDetail<?> access) {
                    return access.getAccessObject().equals(artifact) || access.getAccessObject().equals(artifact.getArtifactType());
                }
            });
            this.setPermissionStatus(permissionStatus, permissionToMatch, mostSpecific);
        }
    }

    public void attributeTypeMatches(PermissionEnum permissionToMatch, ArtifactToken artifact, AttributeTypeId attributeType, PermissionStatus permissionStatus) throws OseeCoreException {
        this.artifactMatches(permissionToMatch, artifact, permissionStatus);
        if (permissionStatus.matched()) {
            Collection<AccessDetail<?>> branchAccessDetails = this.accessData.getAccess(artifact.getBranch());
            ObjectFilter filter = new ObjectFilter(attributeType);
            AccessDetail<?> branchPermission = this.getNetAccess(branchAccessDetails, filter);
            this.setPermissionStatus(permissionStatus, permissionToMatch, branchPermission);
            if (permissionStatus.matched()) {
                Collection<AccessDetail<?>> artifactAccessDetails = this.accessData.getAccess(artifact);
                AccessDetail<?> attributePermission = this.getNetAccess(artifactAccessDetails, filter);
                this.setPermissionStatus(permissionStatus, permissionToMatch, attributePermission);
            }
        }
    }

    public void relationTypeMatches(PermissionEnum permissionToMatch, ArtifactToken artifact, RelationTypeSide relationTypeSide, PermissionStatus permissionStatus) throws OseeCoreException {
        BranchId branchToMatch = artifact.getBranch();
        this.branchMatches(permissionToMatch, branchToMatch, permissionStatus);
        if (permissionStatus.matched()) {
            Collection<AccessDetail<?>> relationAccessDetails = this.accessData.getAccess(artifact);
            RelationTypeSideFilter filter = new RelationTypeSideFilter(relationTypeSide);
            AccessDetail<?> relationDetail = this.getNetAccess(relationAccessDetails, filter);
            this.setPermissionStatus(permissionStatus, permissionToMatch, relationDetail);
        }
    }

    public boolean matchesAll(PermissionEnum permissionToMatch) throws OseeCoreException {
        PermissionStatus permissionStatus = new PermissionStatus();
        for (Object objectKey : this.accessData.keySet()) {
            if (objectKey instanceof ArtifactToken) {
                this.artifactMatches(permissionToMatch, (ArtifactToken)objectKey, permissionStatus);
            } else if (objectKey instanceof BranchId) {
                this.branchMatches(permissionToMatch, (BranchId)objectKey, permissionStatus);
            }
            if (!permissionStatus.matched()) break;
        }
        return permissionStatus.matched();
    }

    private <T> void setTypePermissionStatus(PermissionStatus permissionStatus, PermissionEnum permissionToMatch, Collection<AccessDetail<?>> accessDetails, T toMatch) {
        ObjectFilter filter = new ObjectFilter(toMatch);
        AccessDetail<?> accessDetail = this.getNetAccess(accessDetails, filter);
        this.setPermissionStatus(permissionStatus, permissionToMatch, accessDetail);
    }

    private void setPermissionStatus(PermissionStatus status, PermissionEnum permissionToMatch, AccessDetail<?> mostSpecific) {
        if (mostSpecific == null) {
            return;
        }
        if (mostSpecific.getPermission() == null) {
            status.setMatches(false);
        } else {
            boolean matches = mostSpecific.getPermission().matches(permissionToMatch);
            if (!matches) {
                status.setReason(mostSpecific.getReason());
            }
            status.setMatches(matches);
        }
    }

    private AccessDetail<?> getNetAccess(Collection<AccessDetail<?>> toFilter, AccessFilter filter) {
        AccessDetail<?> mostSpecific = null;
        for (AccessDetail<?> entry : toFilter) {
            if (!filter.accept(entry)) continue;
            mostSpecific = AccessDetail.resolveAccess(mostSpecific, entry);
        }
        return mostSpecific;
    }

    private static interface AccessFilter {
        public boolean accept(AccessDetail<?> var1);
    }

    private class ObjectFilter
    implements AccessFilter {
        Object toFilter;

        ObjectFilter(Object toFilter) {
            this.toFilter = toFilter;
        }

        @Override
        public boolean accept(AccessDetail<?> access) {
            return access.getAccessObject().equals(this.toFilter);
        }
    }

    private class RelationTypeSideFilter
    implements AccessFilter {
        RelationTypeSide toFilter;

        RelationTypeSideFilter(RelationTypeSide toFilter) {
            this.toFilter = toFilter;
        }

        @Override
        public boolean accept(AccessDetail<?> access) {
            if (access.getAccessObject() instanceof RelationTypeSide) {
                RelationTypeSide toCheck = (RelationTypeSide)access.getAccessObject();
                return toCheck.getSide().equals((Object)this.toFilter.getSide()) && toCheck.getGuid().equals(this.toFilter.getGuid());
            }
            return false;
        }
    }
}

