/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model.access;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.osee.framework.core.model.access.AccessDetail;
import org.eclipse.osee.framework.jdk.core.type.CompositeKeyHashMap;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public final class AccessData {
    private final CompositeKeyHashMap<Object, Object, AccessDetail<?>> accessMap = new CompositeKeyHashMap();

    public boolean isEmpty() {
        return this.accessMap.isEmpty();
    }

    public void addAll(Object key, Collection<AccessDetail<?>> datas) throws OseeCoreException {
        Conditions.checkNotNull((Object)key, (String)"access key");
        Conditions.checkNotNull(datas, (String)"accessDetails");
        for (AccessDetail<?> data : datas) {
            this.add(key, data);
        }
    }

    public Set<Object> keySet() {
        HashSet<Object> toReturn = new HashSet<Object>();
        for (Pair key : this.accessMap.keySet()) {
            toReturn.add(key.getFirst());
        }
        return toReturn;
    }

    public void add(Object key, AccessDetail<?> data) throws OseeCoreException {
        Conditions.checkNotNull((Object)key, (String)"access key");
        Conditions.checkNotNull(data, (String)"access data");
        AccessDetail original = (AccessDetail)this.accessMap.get(key, data.getAccessObject());
        AccessDetail<?> resolvedAccess = AccessDetail.resolveAccess(original, data);
        this.accessMap.put(key, data.getAccessObject(), resolvedAccess);
    }

    public Collection<AccessDetail<?>> getAccess(Object key) throws OseeCoreException {
        Conditions.checkNotNull((Object)key, (String)"access key");
        return this.accessMap.getValues(key);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("accessData [");
        if (!this.accessMap.isEmpty()) {
            builder.append("\n");
            for (Object key : this.keySet()) {
                for (AccessDetail detail : this.accessMap.getValues(key)) {
                    builder.append("\t");
                    builder.append(key);
                    builder.append(" - ");
                    builder.append(detail);
                    builder.append(",\n");
                }
            }
        }
        builder.append("]");
        return builder.toString();
    }
}

