/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.account.rest.client.internal;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.eclipse.osee.account.rest.client.AccountClient;
import org.eclipse.osee.account.rest.model.AccountActiveData;
import org.eclipse.osee.account.rest.model.AccountDetailsData;
import org.eclipse.osee.account.rest.model.AccountInfoData;
import org.eclipse.osee.account.rest.model.AccountInput;
import org.eclipse.osee.account.rest.model.AccountLoginData;
import org.eclipse.osee.account.rest.model.AccountPreferencesData;
import org.eclipse.osee.account.rest.model.AccountPreferencesInput;
import org.eclipse.osee.account.rest.model.AccountSessionData;
import org.eclipse.osee.account.rest.model.AccountSessionDetailsData;
import org.eclipse.osee.account.rest.model.AccountWebPreferences;
import org.eclipse.osee.account.rest.model.SubscriptionData;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ResultSets;
import org.eclipse.osee.jaxrs.client.JaxRsClient;
import org.eclipse.osee.jaxrs.client.JaxRsExceptions;
import org.eclipse.osee.jaxrs.client.JaxRsWebTarget;

public class AccountClientImpl
implements AccountClient {
    private static final String OSEE_APPLICATION_SERVER = "osee.application.server";
    private volatile JaxRsClient client;
    private volatile URI baseUri;

    public void start(Map<String, Object> properties) {
        this.update(properties);
    }

    public void stop() {
        this.client = null;
        this.baseUri = null;
    }

    public void update(Map<String, Object> properties) {
        String address;
        this.client = JaxRsClient.newBuilder().properties(properties).build();
        String string = address = properties != null ? (String)properties.get(OSEE_APPLICATION_SERVER) : null;
        if (address == null) {
            address = System.getProperty(OSEE_APPLICATION_SERVER, "");
        }
        this.baseUri = UriBuilder.fromUri((String)address).build(new Object[0]);
    }

    private JaxRsWebTarget newTarget(URI uri) {
        return this.client.target(uri);
    }

    @Override
    public AccountSessionData login(String scheme, String username, String password) {
        AccountLoginData data = new AccountLoginData();
        data.setUsername(username);
        data.setPassword(password);
        data.setScheme(scheme);
        URI uri = UriBuilder.fromUri((URI)this.baseUri).path("accounts").path("login").build(new Object[0]);
        try {
            return (AccountSessionData)this.newTarget(uri).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)data), AccountSessionData.class);
        }
        catch (Exception ex) {
            throw JaxRsExceptions.asOseeException((Throwable)ex);
        }
    }

    @Override
    public boolean logout(AccountSessionData session) {
        URI uri = UriBuilder.fromUri((URI)this.baseUri).path("accounts").path("logout").build(new Object[0]);
        try {
            Response response = this.newTarget(uri).request().post(Entity.json((Object)session));
            return Response.Status.OK.getStatusCode() == response.getStatus();
        }
        catch (Exception ex) {
            throw JaxRsExceptions.asOseeException((Throwable)ex);
        }
    }

    @Override
    public AccountInfoData createAccount(String userName, AccountInput input) {
        URI uri = UriBuilder.fromUri((URI)this.baseUri).path("accounts").path("{username}").build(new Object[]{userName});
        try {
            return (AccountInfoData)this.newTarget(uri).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)input), AccountInfoData.class);
        }
        catch (Exception ex) {
            throw JaxRsExceptions.asOseeException((Throwable)ex);
        }
    }

    @Override
    public boolean deleteAccount(Long accountId) {
        URI uri = UriBuilder.fromUri((URI)this.baseUri).path("accounts").path("{account-id}").build(new Object[]{accountId});
        try {
            Response response = this.newTarget(uri).request().delete();
            return Response.Status.OK.getStatusCode() == response.getStatus();
        }
        catch (Exception ex) {
            throw JaxRsExceptions.asOseeException((Throwable)ex);
        }
    }

    @Override
    public ResultSet<AccountSessionDetailsData> getAccountSessionDataByUniqueField(String accountId) {
        URI uri = UriBuilder.fromUri((URI)this.baseUri).path("accounts").path("{account-id}").path("sessions").build(new Object[]{accountId});
        try {
            Object[] data = (AccountSessionDetailsData[])this.newTarget(uri).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(AccountSessionDetailsData[].class);
            return ResultSets.newResultSet((Object[])data);
        }
        catch (Exception ex) {
            throw JaxRsExceptions.asOseeException((Throwable)ex);
        }
    }

    @Override
    public ResultSet<AccountInfoData> getAllAccounts() {
        URI uri = UriBuilder.fromUri((URI)this.baseUri).path("accounts").build(new Object[0]);
        try {
            Object[] accounts = (AccountInfoData[])this.newTarget(uri).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(AccountInfoData[].class);
            return ResultSets.newResultSet((Object[])accounts);
        }
        catch (Exception ex) {
            throw JaxRsExceptions.asOseeException((Throwable)ex);
        }
    }

    @Override
    public AccountDetailsData getAccountDetailsById(Long accountId) {
        URI uri = UriBuilder.fromUri((URI)this.baseUri).path("accounts").path("{account-id}").build(new Object[]{accountId});
        try {
            return (AccountDetailsData)this.newTarget(uri).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(AccountDetailsData.class);
        }
        catch (Exception ex) {
            throw JaxRsExceptions.asOseeException((Throwable)ex);
        }
    }

    @Override
    public AccountPreferencesData getAccountPreferencesById(Long accountId) {
        URI uri = UriBuilder.fromUri((URI)this.baseUri).path("accounts").path("{account-id}").path("preferences").build(new Object[]{accountId});
        try {
            return (AccountPreferencesData)this.newTarget(uri).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(AccountPreferencesData.class);
        }
        catch (Exception ex) {
            throw JaxRsExceptions.asOseeException((Throwable)ex);
        }
    }

    @Override
    public AccountWebPreferences getAccountWebPreferencesByUniqueField(Long accountId) {
        URI uri = UriBuilder.fromUri((URI)this.baseUri).path("accounts").path("preferences").path("{account-id}").build(new Object[]{accountId});
        try {
            return (AccountWebPreferences)this.newTarget(uri).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(AccountWebPreferences.class);
        }
        catch (Exception ex) {
            throw JaxRsExceptions.asOseeException((Throwable)ex);
        }
    }

    @Override
    public boolean setAccountActive(Long accountId, boolean active) {
        URI uri = UriBuilder.fromUri((URI)this.baseUri).path("accounts").path("{account-id}").path("active").build(new Object[]{accountId});
        boolean result = active ? this.setAccountActive(uri) : this.setAccountInActive(uri);
        return result;
    }

    @Override
    public boolean isAccountActive(Long accountId) {
        URI uri = UriBuilder.fromUri((URI)this.baseUri).path("accounts").path("{account-id}").path("active").build(new Object[]{accountId});
        try {
            AccountActiveData data = (AccountActiveData)this.newTarget(uri).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(AccountActiveData.class);
            return data.isActive();
        }
        catch (Exception ex) {
            throw JaxRsExceptions.asOseeException((Throwable)ex);
        }
    }

    private boolean setAccountActive(URI uri) {
        try {
            Response response = this.newTarget(uri).request().put(null);
            return Response.Status.OK.getStatusCode() == response.getStatus();
        }
        catch (Exception ex) {
            throw JaxRsExceptions.asOseeException((Throwable)ex);
        }
    }

    private boolean setAccountInActive(URI uri) {
        try {
            Response response = this.newTarget(uri).request().delete();
            return Response.Status.OK.getStatusCode() == response.getStatus();
        }
        catch (Exception ex) {
            throw JaxRsExceptions.asOseeException((Throwable)ex);
        }
    }

    @Override
    public boolean setAccountPreferences(Long accountId, Map<String, String> preferences) {
        URI uri = UriBuilder.fromUri((URI)this.baseUri).path("accounts").path("{account-id}").path("preferences").build(new Object[]{accountId});
        AccountPreferencesInput input = new AccountPreferencesInput();
        input.setMap(preferences);
        try {
            Response response = this.newTarget(uri).request().put(Entity.json((Object)input));
            return Response.Status.OK.getStatusCode() == response.getStatus();
        }
        catch (Exception ex) {
            throw JaxRsExceptions.asOseeException((Throwable)ex);
        }
    }

    private ResultSet<SubscriptionData> getSubscriptionsForAccount(Long accountId) {
        URI uri = UriBuilder.fromUri((URI)this.baseUri).path("subscriptions").path("for-account").path("{account-id}").build(new Object[]{accountId});
        try {
            Object[] data = (SubscriptionData[])this.newTarget(uri).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(SubscriptionData[].class);
            return ResultSets.newResultSet((Object[])data);
        }
        catch (Exception ex) {
            throw JaxRsExceptions.asOseeException((Throwable)ex);
        }
    }

    @Override
    public ResultSet<AccountClient.UnsubscribeInfo> getUnsubscribeUris(Long accountId, Collection<String> groupNames) {
        ResultSet toReturn = ResultSets.emptyResultSet();
        ResultSet<SubscriptionData> results = this.getSubscriptionsForAccount(accountId);
        if (!results.isEmpty()) {
            ArrayList<AccountClient.UnsubscribeInfo> infos = new ArrayList<AccountClient.UnsubscribeInfo>();
            UriBuilder builder = UriBuilder.fromUri((URI)this.baseUri).path("unsubscribe").path("ui").path("{subscription-uuid}");
            for (SubscriptionData subscription : results) {
                if (!subscription.isActive() || !groupNames.contains(subscription.getName())) continue;
                String name = subscription.getName();
                URI unsubscribeUri = builder.build(new Object[]{subscription.getGuid()});
                infos.add(this.newUnsubscribeInfo(name, unsubscribeUri));
            }
            toReturn = ResultSets.newResultSet(infos);
        }
        return ResultSets.newResultSet((Iterable)toReturn);
    }

    private AccountClient.UnsubscribeInfo newUnsubscribeInfo(final String subscriptionName, final URI unsubscribeUri) {
        return new AccountClient.UnsubscribeInfo(){

            @Override
            public String getName() {
                return subscriptionName;
            }

            @Override
            public URI getUnsubscribeUri() {
                return unsubscribeUri;
            }
        };
    }

    @Override
    public boolean isLocalHost() {
        return this.baseUri.toString().contains("localhost");
    }

    @Override
    public String getBaseUri() {
        return this.baseUri.toString();
    }
}

