/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.internal.Activator;
import org.eclipse.osee.framework.core.util.IResultDataListener;
import org.eclipse.osee.framework.core.util.XResultData;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;

public final class XResultDataFile
extends XResultData {
    private OutputStreamWriter out;
    private File file;

    public XResultDataFile() {
        this(true, null);
    }

    public XResultDataFile(boolean enableOseeLog) {
        this(enableOseeLog, null);
    }

    public XResultDataFile(boolean enableOseeLog, IResultDataListener ... listeners) {
        super(enableOseeLog, listeners);
        this.clear();
    }

    private File getDirectory() {
        File directory = new File(System.getProperty("java.io.tmpdir"));
        if (!directory.canWrite()) {
            directory = new File(System.getProperty("user.home"));
        }
        return directory;
    }

    @Override
    public void clear() {
        super.clear();
        String filename = String.format("%s.txt", GUID.create());
        this.file = new File(this.getDirectory(), filename);
        try {
            this.out = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), "UTF-8");
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    @Override
    public void addRaw(String str) {
        if (Strings.isValid((String)str)) {
            try {
                this.out.write(str);
            }
            catch (IOException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
    }

    @Override
    public void dispose() {
        Lib.close((Closeable)this.out);
        if (this.file != null && this.file.exists()) {
            this.file.delete();
        }
    }

    @Override
    public String toString() {
        Lib.close((Closeable)this.out);
        String toReturn = null;
        try {
            toReturn = Lib.fileToString((File)this.file);
        }
        catch (IOException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return toReturn;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

