/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.util.IResultDataListener;
import org.eclipse.osee.framework.jdk.core.type.CountingMap;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.IHealthStatus;
import org.eclipse.osee.framework.logging.SevereLoggingMonitor;

public class XResultData {
    public static final Pattern ErrorPattern = Pattern.compile("Error: ");
    public static final Pattern WarningPattern = Pattern.compile("Warning: ");
    public List<IResultDataListener> listeners;
    public String title;
    private StringBuilder sb;
    private CountingMap<Type> count;
    private boolean enableOseeLog;

    public XResultData() {
        this(true);
    }

    public XResultData(boolean enableOseeLog) {
        this.enableOseeLog = enableOseeLog;
        this.clear();
    }

    public XResultData(boolean enableOseeLog, IResultDataListener ... listeners) {
        this.enableOseeLog = enableOseeLog;
        this.clear();
        if (listeners != null && listeners.length > 0) {
            this.listeners = Arrays.asList(listeners);
        }
    }

    public void clear() {
        this.sb = new StringBuilder();
        this.count = new CountingMap();
    }

    public void addRaw(String str) {
        this.sb.append(str);
    }

    public void reportSevereLoggingMonitor(SevereLoggingMonitor monitorLog) {
        List stats = monitorLog.getAllLogs();
        for (IHealthStatus stat : new ArrayList(stats)) {
            if (stat.getException() == null) continue;
            this.error("Exception: " + Lib.exceptionToString((Throwable)stat.getException()));
        }
    }

    public void log(IProgressMonitor monitor, String str) {
        this.log(str);
        if (monitor != null) {
            monitor.setTaskName(str);
        }
    }

    public void log(String str) {
        this.logStr(Type.Info, String.valueOf(str) + "\n");
    }

    public void logf(String formatStr, Object ... objs) {
        this.logStr(Type.Info, String.format(formatStr, objs));
    }

    public void error(String str) {
        this.logStr(Type.Severe, String.valueOf(str) + "\n");
    }

    public void errorf(String formatStr, Object ... objs) {
        this.logStr(Type.Severe, String.format(String.valueOf(formatStr) + "\n", objs));
    }

    public void warning(String str) {
        this.logStr(Type.Warning, String.valueOf(str) + "\n");
    }

    public void warningf(String formatStr, Object ... objs) {
        this.logStr(Type.Warning, String.format(String.valueOf(formatStr) + "\n", objs));
    }

    public boolean isEmpty() {
        return this.toString().equals("");
    }

    public void bumpCount(Type type, int byAmt) {
        this.count.put((Object)type, byAmt);
    }

    public void logStr(Type type, String str) {
        this.bumpCount(type, 1);
        String resultStr = "";
        resultStr = type == Type.Warning ? "Warning: " + str : (type == Type.Severe ? "Error: " + str : str);
        this.addRaw(resultStr);
        if (this.listeners != null) {
            for (IResultDataListener listener : this.listeners) {
                listener.log(type, resultStr);
            }
        }
    }

    public void dispose() {
    }

    public String toString() {
        return this.sb.toString();
    }

    private int getCount(Type type) {
        return this.count.get((Object)type);
    }

    public int getNumErrors() {
        return this.getCount(Type.Severe);
    }

    public int getNumErrorsViaSearch() {
        return Lib.getMatcherCount((Pattern)ErrorPattern, (String)this.toString());
    }

    public int getNumWarningsViaSearch() {
        return Lib.getMatcherCount((Pattern)WarningPattern, (String)this.toString());
    }

    public int getNumWarnings() {
        return this.getCount(Type.Warning);
    }

    public boolean isEnableOseeLog() {
        return this.enableOseeLog;
    }

    public void setEnableOseeLog(boolean enableOseeLog) {
        this.enableOseeLog = enableOseeLog;
    }

    public boolean isErrors() {
        return this.getNumErrors() > 0;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public static enum Type {
        Severe,
        Warning,
        Info;

    }
}

