/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.eclipse.core.net.proxy.IProxyChangeEvent;
import org.eclipse.core.net.proxy.IProxyChangeListener;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.osee.framework.core.internal.Activator;
import org.eclipse.osee.framework.core.util.DeleteMethod;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.OseeProperties;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class HttpProcessor {
    private static final String CONTENT_TYPE = "content-type";
    private static final String CONTENT_ENCODING = "content-encoding";
    private static final long CHECK_WINDOW = 5000L;
    private static final MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
    private static final HttpClient client = new HttpClient((HttpConnectionManager)connectionManager);
    private static IProxyService proxyService;
    private static final Map<String, IProxyData[]> proxiedData;
    private static int requests;
    private static final Map<String, Pair<Integer, Long>> isAliveMap;

    static {
        proxiedData = new ConcurrentHashMap<String, IProxyData[]>();
        requests = 0;
        isAliveMap = new ConcurrentHashMap<String, Pair<Integer, Long>>();
    }

    private HttpProcessor() {
    }

    private static HttpClient getHttpClient(URI uri) {
        HostConfiguration config = client.getHostConfiguration();
        HttpProcessor.configureProxyData(uri, config);
        return client;
    }

    private static void configureProxyData(URI uri, HostConfiguration config) {
        boolean proxyBypass = OseeProperties.getOseeProxyBypassEnabled();
        if (!proxyBypass) {
            String key;
            IProxyData[] datas;
            if (proxyService == null) {
                BundleContext context = Activator.getBundleContext();
                if (context != null) {
                    ServiceReference reference = context.getServiceReference(IProxyService.class);
                    proxyService = (IProxyService)context.getService(reference);
                }
                if (proxyService != null) {
                    proxyService.addProxyChangeListener(new IProxyChangeListener(){

                        public void proxyInfoChanged(IProxyChangeEvent event) {
                            proxiedData.clear();
                        }
                    });
                }
            }
            if ((datas = proxiedData.get(key = String.format("%s_%s", uri.getScheme(), uri.getHost()))) == null && proxyService != null) {
                datas = proxyService.select(uri);
                proxiedData.put(key, datas);
            }
            if (datas != null) {
                IProxyData[] iProxyDataArray = datas;
                int n = datas.length;
                int n2 = 0;
                while (n2 < n) {
                    IProxyData data = iProxyDataArray[n2];
                    config.setProxy(data.getHost(), data.getPort());
                    ++n2;
                }
            }
        }
        OseeLog.logf(Activator.class, (Level)Level.INFO, (String)"Http-Request: [%s] [%s]", (Object[])new Object[]{requests++, uri.toASCIIString()});
    }

    public static String acquireString(URL url) throws Exception {
        try (ByteArrayOutputStream sourceOutputStream = new ByteArrayOutputStream();){
            AcquireResult result = HttpProcessor.acquire(url, sourceOutputStream);
            if (result.getCode() == 200) {
                String string = sourceOutputStream.toString();
                return string;
            }
        }
        return null;
    }

    private static void cacheAlive(URL url, int code) {
        String key = HttpProcessor.toIsAliveKey(url);
        isAliveMap.put(key, (Pair<Integer, Long>)new Pair((Object)code, (Object)System.currentTimeMillis()));
    }

    private static int executeMethod(URL url, HttpMethodBase method) throws HttpException, IOException, URISyntaxException {
        int statusCode = -1;
        try {
            statusCode = HttpProcessor.getHttpClient(url.toURI()).executeMethod((HttpMethod)method);
        }
        finally {
            HttpProcessor.cacheAlive(url, statusCode);
        }
        return statusCode;
    }

    private static String toIsAliveKey(URL url) {
        String host = url.getHost();
        int port = url.getPort();
        return String.format("%s_%s", host, port);
    }

    public static boolean isAlive(URL url) {
        long checkedOffset;
        boolean isAlive = false;
        boolean recheck = true;
        String key = HttpProcessor.toIsAliveKey(url);
        Pair<Integer, Long> lastChecked = isAliveMap.get(key);
        if (lastChecked != null && (checkedOffset = System.currentTimeMillis() - (Long)lastChecked.getSecond()) < 5000L) {
            recheck = false;
            boolean bl = isAlive = (Integer)lastChecked.getFirst() != -1;
        }
        if (recheck) {
            try {
                GetMethod method = new GetMethod(url.toString());
                try {
                    HttpMethodParams params = new HttpMethodParams();
                    params.setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(0, false));
                    params.setSoTimeout(1000);
                    method.setParams(params);
                    int responseCode = HttpProcessor.executeMethod(url, (HttpMethodBase)method);
                    if (responseCode == 404 || responseCode == 202 || responseCode == 202 || responseCode == 200) {
                        isAlive = true;
                    }
                }
                finally {
                    method.releaseConnection();
                }
            }
            catch (Exception exception) {}
        }
        return isAlive;
    }

    public static boolean isAlive(URI uri) {
        boolean isAlive = false;
        try {
            isAlive = HttpProcessor.isAlive(uri.toURL());
        }
        catch (MalformedURLException malformedURLException) {}
        return isAlive;
    }

    public static URI save(URL url, InputStream inputStream, String contentType, String encoding) throws Exception {
        String locator = HttpProcessor.put(url, inputStream, contentType, encoding);
        return new URI(locator);
    }

    public static String put(URL url, InputStream inputStream, String contentType, String encoding) throws OseeCoreException {
        String response;
        block6: {
            int statusCode = -1;
            response = null;
            PutMethod method = new PutMethod(url.toString());
            InputStream responseInputStream = null;
            AcquireResult result = new AcquireResult();
            try {
                try {
                    method.setRequestHeader(CONTENT_ENCODING, encoding);
                    method.setRequestEntity((RequestEntity)new InputStreamRequestEntity(inputStream, contentType));
                    method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
                    statusCode = HttpProcessor.executeMethod(url, (HttpMethodBase)method);
                    responseInputStream = method.getResponseBodyAsStream();
                    result.setContentType(HttpProcessor.getContentType((HttpMethodBase)method));
                    result.setEncoding(method.getResponseCharSet());
                    if (statusCode != 201) {
                        String exceptionString = Lib.inputStreamToString((InputStream)responseInputStream);
                        throw new OseeCoreException(exceptionString, new Object[0]);
                    }
                    responseInputStream = method.getResponseBodyAsStream();
                    response = Lib.inputStreamToString((InputStream)responseInputStream);
                }
                catch (Exception ex) {
                    OseeCoreException.wrapAndThrow((Throwable)ex);
                    Lib.close(responseInputStream);
                    method.releaseConnection();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                Lib.close(responseInputStream);
                method.releaseConnection();
                throw throwable;
            }
            Lib.close((Closeable)responseInputStream);
            method.releaseConnection();
        }
        return response;
    }

    public static AcquireResult delete(URL url, String xml, String contentType, String encoding, OutputStream outputStream) throws OseeCoreException {
        AcquireResult result;
        block6: {
            result = new AcquireResult();
            int statusCode = -1;
            DeleteMethod method = new DeleteMethod(url.toString());
            InputStream httpInputStream = null;
            try {
                try {
                    method.setRequestHeader(CONTENT_ENCODING, encoding);
                    method.setRequestEntity((RequestEntity)new InputStreamRequestEntity(Lib.stringToInputStream((String)xml), contentType));
                    method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
                    statusCode = HttpProcessor.executeMethod(url, (HttpMethodBase)method);
                    httpInputStream = method.getResponseBodyAsStream();
                    result.setContentType(HttpProcessor.getContentType((HttpMethodBase)method));
                    result.setEncoding(method.getResponseCharSet());
                    if (statusCode != 202 && statusCode != 200) {
                        String exceptionString = Lib.inputStreamToString((InputStream)httpInputStream);
                        throw new OseeCoreException(exceptionString, new Object[0]);
                    }
                    Lib.inputStreamToOutputStream((InputStream)httpInputStream, (OutputStream)outputStream);
                }
                catch (Exception ex) {
                    OseeCoreException.wrapAndThrow((Throwable)ex);
                    Lib.close(httpInputStream);
                    result.setCode(statusCode);
                    method.releaseConnection();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                Lib.close(httpInputStream);
                result.setCode(statusCode);
                method.releaseConnection();
                throw throwable;
            }
            Lib.close((Closeable)httpInputStream);
            result.setCode(statusCode);
            method.releaseConnection();
        }
        return result;
    }

    public static AcquireResult post(URL url, InputStream inputStream, String contentType, String encoding, OutputStream outputStream) throws OseeCoreException {
        AcquireResult result;
        block6: {
            result = new AcquireResult();
            int statusCode = -1;
            PostMethod method = new PostMethod(url.toString());
            InputStream httpInputStream = null;
            try {
                try {
                    method.setRequestHeader(CONTENT_ENCODING, encoding);
                    method.setRequestEntity((RequestEntity)new InputStreamRequestEntity(inputStream, contentType));
                    method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
                    statusCode = HttpProcessor.executeMethod(url, (HttpMethodBase)method);
                    httpInputStream = method.getResponseBodyAsStream();
                    result.setContentType(HttpProcessor.getContentType((HttpMethodBase)method));
                    result.setEncoding(method.getResponseCharSet());
                    if (statusCode != 202 && statusCode != 200) {
                        String exceptionString = Lib.inputStreamToString((InputStream)httpInputStream);
                        throw new OseeCoreException(exceptionString, new Object[0]);
                    }
                    Lib.inputStreamToOutputStream((InputStream)httpInputStream, (OutputStream)outputStream);
                }
                catch (Exception ex) {
                    OseeCoreException.wrapAndThrow((Throwable)ex);
                    Lib.close(httpInputStream);
                    result.setCode(statusCode);
                    method.releaseConnection();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                Lib.close(httpInputStream);
                result.setCode(statusCode);
                method.releaseConnection();
                throw throwable;
            }
            Lib.close((Closeable)httpInputStream);
            result.setCode(statusCode);
            method.releaseConnection();
        }
        return result;
    }

    public static String post(URL url) throws Exception {
        AcquireResult result = new AcquireResult();
        String response = null;
        int statusCode = -1;
        PostMethod method = new PostMethod(url.toString());
        InputStream responseInputStream = null;
        try {
            method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
            statusCode = HttpProcessor.executeMethod(url, (HttpMethodBase)method);
            responseInputStream = method.getResponseBodyAsStream();
            result.setContentType(HttpProcessor.getContentType((HttpMethodBase)method));
            result.setEncoding(method.getResponseCharSet());
            if (statusCode != 202) {
                String exceptionString = Lib.inputStreamToString((InputStream)responseInputStream);
                throw new Exception(exceptionString);
            }
            responseInputStream = method.getResponseBodyAsStream();
            response = Lib.inputStreamToString((InputStream)responseInputStream);
        }
        catch (Throwable throwable) {
            Lib.close(responseInputStream);
            method.releaseConnection();
            throw throwable;
        }
        Lib.close((Closeable)responseInputStream);
        method.releaseConnection();
        return response;
    }

    private static String getContentType(HttpMethodBase method) {
        int index;
        String contentType = null;
        Header header = method.getResponseHeader(CONTENT_TYPE);
        if (header != null && Strings.isValid((String)(contentType = header.getValue())) && (index = contentType.indexOf(59)) > 0) {
            contentType = contentType.substring(0, index);
        }
        return contentType;
    }

    public static AcquireResult acquire(URL url, OutputStream outputStream) throws Exception {
        return HttpProcessor.acquire(url, outputStream, 0);
    }

    public static AcquireResult acquire(URL url, OutputStream outputStream, int soTimeout) throws Exception {
        AcquireResult result = new AcquireResult();
        int statusCode = -1;
        GetMethod method = new GetMethod(url.toString());
        InputStream inputStream = null;
        try {
            try {
                method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
                method.getParams().setSoTimeout(soTimeout);
                statusCode = HttpProcessor.executeMethod(url, (HttpMethodBase)method);
                result.setEncoding(method.getResponseCharSet());
                result.setContentType(HttpProcessor.getContentType((HttpMethodBase)method));
                if (statusCode == 200 || statusCode == 202) {
                    inputStream = method.getResponseBodyAsStream();
                    Lib.inputStreamToOutputStream((InputStream)inputStream, (OutputStream)outputStream);
                } else {
                    String response = method.getResponseBodyAsString();
                    result.setResult(response);
                }
            }
            catch (Exception ex) {
                throw new Exception(String.format("Error acquiring resource: [%s] - status code: [%s]", url, statusCode), ex);
            }
        }
        catch (Throwable throwable) {
            Lib.close(inputStream);
            result.setCode(statusCode);
            method.releaseConnection();
            throw throwable;
        }
        Lib.close((Closeable)inputStream);
        result.setCode(statusCode);
        method.releaseConnection();
        return result;
    }

    public static String delete(URL url) throws Exception {
        String response = null;
        int statusCode = -1;
        DeleteMethod method = new DeleteMethod(url.toString());
        InputStream responseInputStream = null;
        try {
            try {
                method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
                statusCode = HttpProcessor.executeMethod(url, (HttpMethodBase)method);
                if (statusCode == 202) {
                    responseInputStream = method.getResponseBodyAsStream();
                    response = Lib.inputStreamToString((InputStream)responseInputStream);
                }
            }
            catch (Exception ex) {
                throw new Exception(String.format("Error deleting resource: [%s] - status code: [%s]", url, statusCode), ex);
            }
        }
        finally {
            Lib.close(responseInputStream);
            method.releaseConnection();
        }
        return response;
    }

    public static final class AcquireResult {
        private int code = -1;
        private String encoding = "";
        private String contentType = "";
        private String result;

        private AcquireResult() {
        }

        public boolean wasSuccessful() {
            return this.code == 200 || this.code == 202;
        }

        public int getCode() {
            return this.code;
        }

        private void setCode(int code) {
            this.code = code;
        }

        public String getEncoding() {
            return this.encoding;
        }

        private void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public String getContentType() {
            return this.contentType;
        }

        private void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public String getResult() {
            return this.result;
        }

        public void setResult(String result) {
            this.result = result;
        }
    }
}

