/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.threading;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.osee.framework.core.threading.ThreadedWorkerFactory;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public class ThreadedWorkerExecutor<T> {
    private final int numberOfWorkers;
    private final ThreadedWorkerFactory<T> factory;

    public ThreadedWorkerExecutor(ThreadedWorkerFactory<T> factory, boolean ioBound) {
        this(factory, ioBound ? Runtime.getRuntime().availableProcessors() * 2 : Runtime.getRuntime().availableProcessors());
    }

    public ThreadedWorkerExecutor(ThreadedWorkerFactory<T> factory, int numberOfWorkers) {
        this.factory = factory;
        this.numberOfWorkers = numberOfWorkers;
    }

    public List<T> executeWorkersBlocking() throws OseeCoreException {
        ExecutorService executor = Executors.newFixedThreadPool(this.numberOfWorkers);
        LinkedList<T> toReturn = new LinkedList<T>();
        Collection<Callable<T>> workers = this.createWorkers();
        try {
            try {
                for (Future<T> future : executor.invokeAll(workers)) {
                    toReturn.add(future.get());
                }
            }
            catch (Exception ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
                executor.shutdown();
            }
        }
        finally {
            executor.shutdown();
        }
        return toReturn;
    }

    private Collection<Callable<T>> createWorkers() {
        int partitionSize = this.factory.getWorkSize() / this.numberOfWorkers;
        int remainder = this.factory.getWorkSize() % this.numberOfWorkers;
        int startIndex = 0;
        int endIndex = 0;
        LinkedList<Callable<T>> workers = new LinkedList<Callable<T>>();
        int i = 0;
        while (i < this.numberOfWorkers) {
            startIndex = endIndex;
            endIndex = startIndex + partitionSize;
            if (i == 0) {
                endIndex += remainder;
            }
            workers.add(this.factory.createWorker(startIndex, endIndex));
            ++i;
        }
        return workers;
    }
}

