/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.ops;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.core.operation.OperationLogger;
import org.eclipse.osee.framework.jdk.core.text.change.ChangeSet;
import org.eclipse.osee.framework.jdk.core.text.rules.ReplaceAll;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public class RenameFilesOperation
extends AbstractOperation {
    private final CharSequence parentFolderPath;
    private final CharSequence pathPattern;
    private final CharSequence replacement;
    private final boolean recurseFiles;

    public RenameFilesOperation(OperationLogger logger, CharSequence parentFolderPath, CharSequence pathPattern, CharSequence replacement) {
        this(logger, parentFolderPath, pathPattern, replacement, true);
    }

    public RenameFilesOperation(OperationLogger logger, CharSequence parentFolderPath, CharSequence pathPattern, CharSequence replacement, boolean recurseFiles) {
        super("Rename Files", "org.eclipse.osee.framework.core", logger);
        this.parentFolderPath = parentFolderPath;
        this.pathPattern = pathPattern;
        this.replacement = replacement;
        this.recurseFiles = recurseFiles;
    }

    @Override
    protected void doWork(IProgressMonitor monitor) throws Exception {
        this.logf("Starting %s", this.getClass().getSimpleName());
        ReplaceAll rule = new ReplaceAll(Pattern.compile(this.pathPattern.toString()), this.replacement.toString());
        File parentFolder = new File(this.parentFolderPath.toString()).getCanonicalFile();
        List<File> files = this.recurseFiles ? Lib.recursivelyListFiles((File)parentFolder) : Arrays.asList(parentFolder.listFiles());
        int size = files.size();
        int renamedFileCount = 0;
        int i = 0;
        while (i < size) {
            if (monitor.isCanceled()) {
                return;
            }
            File file = files.get(i);
            rule.setRuleWasApplicable(false);
            ChangeSet newName = rule.computeChanges((CharSequence)file.getPath());
            if (rule.ruleWasApplicable()) {
                File newFile = new File(newName.toString());
                if (file.renameTo(newFile)) {
                    this.logf("%s became %s", file.getPath(), newFile.getPath());
                    ++renamedFileCount;
                } else {
                    this.logf("%s failed to become %s", file.getPath(), newFile.getPath());
                }
            }
            ++i;
        }
        this.logf("Renamed %d files.", renamedFileCount);
    }
}

