/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.operation;

import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.internal.Activator;
import org.eclipse.osee.framework.jdk.core.util.OseeProperties;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;

public class LogProgressMonitor
implements IProgressMonitor {
    private boolean isCancelled = false;
    private String taskName = "";

    public void beginTask(String name, int totalWork) {
        this.taskName = name;
        if (!OseeProperties.isInTest()) {
            OseeLog.logf(Activator.class, (Level)Level.INFO, (String)"Start: %s", (Object[])new Object[]{this.taskName});
        }
    }

    public void done() {
        if (!OseeProperties.isInTest()) {
            OseeLog.logf(Activator.class, (Level)Level.INFO, (String)"Finish: %s", (Object[])new Object[]{this.taskName});
        }
    }

    public void internalWorked(double work) {
    }

    public boolean isCanceled() {
        return this.isCancelled;
    }

    public void setCanceled(boolean value) {
        this.isCancelled = value;
    }

    public void setTaskName(String name) {
        if (Strings.isValid((String)name)) {
            this.taskName = name;
            if (!OseeProperties.isInTest()) {
                OseeLog.log(Activator.class, (Level)Level.INFO, (String)name);
            }
        }
    }

    public void subTask(String name) {
        if (Strings.isValid((String)name)) {
            OseeLog.log(Activator.class, (Level)Level.FINER, (String)name);
        }
    }

    public void worked(int work) {
    }
}

