/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.operation;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.NullOperationLogger;
import org.eclipse.osee.framework.core.operation.OperationLogger;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public abstract class AbstractOperation
implements IOperation {
    private IStatus status;
    private final String pluginId;
    private final String name;
    private boolean wasExecuted = false;
    private final OperationLogger logger;

    public AbstractOperation(String operationName, String pluginId) {
        this(operationName, pluginId, NullOperationLogger.getSingleton());
    }

    public AbstractOperation(String operationName, String pluginId, OperationLogger logger) {
        this.name = operationName;
        this.logger = logger;
        this.pluginId = Strings.isValid((String)pluginId) ? pluginId : this.getClass().getPackage().getName();
    }

    public String getName() {
        return this.name;
    }

    protected void setStatus(IStatus status) {
        this.status = status;
    }

    public final boolean wasExecuted() {
        return this.wasExecuted;
    }

    @Override
    public final IStatus run(SubMonitor subMonitor) {
        block5: {
            this.setStatus(null);
            this.wasExecuted = true;
            try {
                try {
                    this.doWork((IProgressMonitor)subMonitor);
                }
                catch (Throwable throwable) {
                    this.setStatusFromThrowable(throwable);
                    this.doFinally((IProgressMonitor)subMonitor);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.doFinally((IProgressMonitor)subMonitor);
                throw throwable;
            }
            this.doFinally((IProgressMonitor)subMonitor);
        }
        return this.status == null ? Status.OK_STATUS : this.status;
    }

    protected void doFinally(IProgressMonitor monitor) {
    }

    protected abstract void doWork(IProgressMonitor var1) throws Exception;

    private void setStatusFromThrowable(Throwable throwable) {
        if (throwable instanceof OperationCanceledException) {
            this.setStatus(Status.CANCEL_STATUS);
        } else {
            this.setStatus((IStatus)new Status(4, this.pluginId, throwable.toString(), throwable));
        }
    }

    protected final int calculateWork(double workPercentage) {
        return Operations.calculateWork(Integer.MAX_VALUE, workPercentage);
    }

    public final IStatus doSubWork(IOperation operation, IProgressMonitor parentMonitor, double workPercentage) throws OseeCoreException {
        IStatus status = Operations.executeWork(operation, parentMonitor);
        AbstractOperation.checkForCancelledStatus(parentMonitor);
        Operations.checkForErrorStatus(status);
        return status;
    }

    public static final void checkForCancelledStatus(IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public String toString() {
        return this.getName();
    }

    protected final String getPluginId() {
        return this.pluginId;
    }

    protected final void log(String ... row) {
        this.logger.log(row);
    }

    protected final void log(Throwable th) {
        this.logger.log(th);
    }

    protected final void log(IStatus status) {
        this.logger.log(status);
    }

    protected final void logf(String format, Object ... args) {
        this.logger.logf(format, args);
    }

    @Override
    public OperationLogger getLogger() {
        return this.logger;
    }
}

