/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.internal;

import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.framework.core.internal.AbstractServiceBinder;
import org.eclipse.osee.framework.core.internal.MultiServiceBinder;
import org.eclipse.osee.framework.core.internal.SingletonServiceBinder;
import org.eclipse.osee.framework.core.util.AbstractTrackingHandler;
import org.eclipse.osee.framework.core.util.ServiceBindType;
import org.eclipse.osee.framework.core.util.ServiceBinderFactory;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public final class ServiceBinderFactoryImpl
implements ServiceBinderFactory {
    private final AbstractServiceBinder singleBinder;
    private final AbstractServiceBinder multiBinder;

    public ServiceBinderFactoryImpl(BundleContext context, AbstractTrackingHandler handler) {
        ConcurrentHashMap serviceMap = new ConcurrentHashMap();
        this.singleBinder = new SingletonServiceBinder(serviceMap, context, handler);
        this.multiBinder = new MultiServiceBinder(serviceMap, context, handler);
    }

    public ServiceTracker<?, ?> createTracker(ServiceBindType bindType, Class<?> clazz) throws OseeStateException {
        AbstractServiceBinder binder = null;
        if (ServiceBindType.SINGLETON == bindType) {
            binder = this.singleBinder;
        } else if (ServiceBindType.MANY == bindType) {
            binder = this.multiBinder;
        }
        if (binder == null) {
            throw new OseeStateException(String.format("Unknown bind type: [%s:%s]", new Object[]{clazz.getName(), bindType}), new Object[0]);
        }
        return binder.createTracker(clazz);
    }
}

