/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.framework.core.enums.OperationBehavior;
import org.eclipse.osee.framework.core.internal.WeightedCompositeOperation;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.NullOperationLogger;
import org.eclipse.osee.framework.core.operation.OperationBuilder;
import org.eclipse.osee.framework.core.operation.OperationLogger;
import org.eclipse.osee.framework.jdk.core.type.Pair;

public class OperationBuilderImpl
implements OperationBuilder {
    private final String name;
    private final String pluginId;
    private OperationBehavior behavior;
    private OperationLogger logger;
    private List<Pair<Double, ? extends IOperation>> operations;
    private double runningTotal;
    private int itemsWithHints;

    public OperationBuilderImpl(String name, String pluginId) {
        this.name = name;
        this.pluginId = pluginId;
        this.reset();
    }

    private void reset() {
        this.behavior = OperationBehavior.TerminateOnError;
        this.logger = NullOperationLogger.getSingleton();
        this.operations = new ArrayList<Pair<Double, ? extends IOperation>>();
        this.runningTotal = 0.0;
        this.itemsWithHints = 0;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public OperationBehavior getExecutionBehavior() {
        return this.behavior;
    }

    @Override
    public OperationLogger getLogger() {
        return this.logger;
    }

    @Override
    public OperationBuilder executionBehavior(OperationBehavior behavior) {
        if (behavior != null) {
            this.behavior = behavior;
        }
        return this;
    }

    @Override
    public OperationBuilder logger(OperationLogger logger) {
        if (logger != null) {
            this.logger = logger;
        }
        return this;
    }

    @Override
    public OperationBuilder addOp(IOperation op) {
        this.operations.add(this.createEntryWithNoHint(op));
        return this;
    }

    @Override
    public OperationBuilder addOp(double weight, IOperation op) {
        double value = Math.abs(weight);
        this.runningTotal += value;
        ++this.itemsWithHints;
        this.operations.add(this.createEntry(value, op));
        return this;
    }

    @Override
    public OperationBuilder addAll(List<? extends IOperation> operations) {
        for (IOperation iOperation : operations) {
            this.addOp(iOperation);
        }
        return this;
    }

    @Override
    public synchronized IOperation build() {
        WeightedCompositeOperation operation = new WeightedCompositeOperation(this.getName(), this.pluginId, this.getExecutionBehavior(), this.getLogger(), this.runningTotal, this.itemsWithHints, this.operations);
        this.reset();
        return operation;
    }

    private Pair<Double, IOperation> createEntry(Double weight, IOperation op) {
        return new Pair((Object)weight, (Object)op);
    }

    private Pair<Double, IOperation> createEntryWithNoHint(IOperation op) {
        return new Pair((Object)WeightedCompositeOperation.EMPTY_WEIGHT_HINT, (Object)op);
    }
}

