/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.osee.framework.core.util.AbstractTrackingHandler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public abstract class AbstractServiceBinder {
    private final Map<Class<?>, Collection<Object>> serviceMap;
    private final BundleContext bundleContext;
    private final AbstractTrackingHandler handler;
    private boolean isReady;

    protected AbstractServiceBinder(Map<Class<?>, Collection<Object>> serviceMap, BundleContext bundleContext, AbstractTrackingHandler handler) {
        this.serviceMap = serviceMap;
        this.bundleContext = bundleContext;
        this.handler = handler;
    }

    protected AbstractTrackingHandler getHandler() {
        return this.handler;
    }

    protected BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public ServiceTracker createTracker(Class<?> clazz) {
        this.serviceMap.put(clazz, new CopyOnWriteArraySet());
        return new InternalServiceTracker(this, this.getBundleContext(), clazz);
    }

    protected abstract void doAdd(Collection<Object> var1, Object var2);

    public void onAddingService(Class<?> classKey, Object service) {
        Collection<Object> associatedServices = this.serviceMap.get(classKey);
        this.doAdd(associatedServices, service);
        if (!this.isReady) {
            if (this.areServicesReady()) {
                this.isReady = true;
                HashSet<Object> servicesReported = new HashSet<Object>();
                HashMap services = new HashMap();
                for (Map.Entry<Class<?>, Collection<Object>> entry : this.serviceMap.entrySet()) {
                    Object serviceObject = entry.getValue().iterator().next();
                    servicesReported.add(serviceObject);
                    services.put(entry.getKey(), serviceObject);
                }
                this.getHandler().onActivate(this.getBundleContext(), services);
                for (Map.Entry<Class<?>, Collection<Object>> entry : this.serviceMap.entrySet()) {
                    for (Object serviceObject : entry.getValue()) {
                        if (servicesReported.contains(serviceObject)) continue;
                        this.getHandler().onServiceAdded(this.getBundleContext(), entry.getKey(), serviceObject);
                    }
                }
            }
        } else {
            this.getHandler().onServiceAdded(this.getBundleContext(), classKey, service);
        }
    }

    public void onRemovingService(Class<?> classKey, Object service) {
        Collection<Object> associatedServices = this.serviceMap.get(classKey);
        boolean wasRemoved = associatedServices.remove(service);
        if (!wasRemoved) {
            throw new IllegalStateException(String.format("Attempting to remove none managed service reference: [%s]", service.getClass().getName()));
        }
        this.getHandler().onServiceRemoved(this.getBundleContext(), classKey, service);
        if (associatedServices.isEmpty()) {
            this.isReady = false;
            this.getHandler().onDeActivate();
        }
    }

    protected boolean areServicesReady() {
        for (Collection<Object> services : this.serviceMap.values()) {
            if (!services.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static final class InternalServiceTracker
    extends ServiceTracker {
        private final AbstractServiceBinder listener;
        private final Class<?> serviceClass;

        public InternalServiceTracker(AbstractServiceBinder listener, BundleContext context, Class<?> serviceClass) {
            super(context, serviceClass.getName(), null);
            this.listener = listener;
            this.serviceClass = serviceClass;
        }

        public Object addingService(ServiceReference reference) {
            Object object = super.addingService(reference);
            this.listener.onAddingService(this.serviceClass, object);
            return object;
        }

        public void removedService(ServiceReference reference, Object service) {
            this.listener.onRemovingService(this.serviceClass, service);
            super.removedService(reference, service);
        }
    }
}

