/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.enums;

import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;

public enum TxChange {
    NOT_CURRENT(0),
    CURRENT(1),
    DELETED(2),
    ARTIFACT_DELETED(3);

    private int value;

    private TxChange(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isDeleted() {
        return this == DELETED || this == ARTIFACT_DELETED;
    }

    public boolean isCurrent() {
        return this != NOT_CURRENT;
    }

    public static TxChange getChangeType(int value) throws OseeArgumentException {
        TxChange[] txChangeArray = TxChange.values();
        int n = txChangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TxChange change = txChangeArray[n2];
            if (change.getValue() == value) {
                return change;
            }
            ++n2;
        }
        throw new OseeArgumentException("[%s] does not correspond to any defined ModificationType enumerations", new Object[]{value});
    }

    public static TxChange getCurrent(ModificationType type) {
        TxChange txChange = null;
        txChange = type == ModificationType.DELETED ? DELETED : (type == ModificationType.ARTIFACT_DELETED ? ARTIFACT_DELETED : CURRENT);
        return txChange;
    }
}

