/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.enums;

import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public enum RelationTypeMultiplicity {
    ONE_TO_ONE(0, 1, 1),
    ONE_TO_MANY(1, 1, Integer.MAX_VALUE),
    MANY_TO_ONE(2, Integer.MAX_VALUE, 1),
    MANY_TO_MANY(3, Integer.MAX_VALUE, Integer.MAX_VALUE);

    private final int value;
    private final int alimit;
    private final int blimit;

    private RelationTypeMultiplicity(int value, int alimit, int blimit) {
        this.value = value;
        this.alimit = alimit;
        this.blimit = blimit;
    }

    public int getSideALimit() {
        return this.alimit;
    }

    public int getSideBLimit() {
        return this.blimit;
    }

    private String limitToString(int limit) {
        return limit == Integer.MAX_VALUE ? "n" : "1";
    }

    public String getSideALimitLabel() {
        return this.limitToString(this.getSideALimit());
    }

    public String getSideBLimitLabel() {
        return this.limitToString(this.getSideBLimit());
    }

    public int getValue() {
        return this.value;
    }

    public String asLimitLabel(RelationSide side) throws OseeCoreException {
        String toReturn;
        switch (side) {
            case SIDE_A: {
                toReturn = this.getSideALimitLabel();
                break;
            }
            case SIDE_B: {
                toReturn = this.getSideBLimitLabel();
                break;
            }
            default: {
                throw new OseeArgumentException("Expecting SIDE_A or SIDE_B", new Object[0]);
            }
        }
        return toReturn;
    }

    public int getLimit(RelationSide side) throws OseeCoreException {
        int limit = -1;
        switch (side) {
            case SIDE_A: {
                limit = this.getSideALimit();
                break;
            }
            case SIDE_B: {
                limit = this.getSideBLimit();
                break;
            }
            default: {
                throw new OseeArgumentException("Expecting SIDE_A or SIDE_B", new Object[0]);
            }
        }
        return limit;
    }

    public boolean isWithinLimit(RelationSide side, int nextCount) throws OseeCoreException {
        int limit = this.getLimit(side);
        boolean result = limit == Integer.MAX_VALUE ? true : nextCount <= limit;
        return result;
    }

    public static RelationTypeMultiplicity getFromString(String value) {
        RelationTypeMultiplicity toReturn = null;
        if (Strings.isValid((String)value)) {
            String toMatch = value.toLowerCase();
            RelationTypeMultiplicity[] relationTypeMultiplicityArray = RelationTypeMultiplicity.values();
            int n = relationTypeMultiplicityArray.length;
            int n2 = 0;
            while (n2 < n) {
                RelationTypeMultiplicity type = relationTypeMultiplicityArray[n2];
                if (type.toString().toLowerCase().equals(toMatch)) {
                    toReturn = type;
                    break;
                }
                ++n2;
            }
        }
        return toReturn;
    }

    public static RelationTypeMultiplicity getRelationMultiplicity(int value) {
        RelationTypeMultiplicity toReturn = null;
        RelationTypeMultiplicity[] relationTypeMultiplicityArray = RelationTypeMultiplicity.values();
        int n = relationTypeMultiplicityArray.length;
        int n2 = 0;
        while (n2 < n) {
            RelationTypeMultiplicity type = relationTypeMultiplicityArray[n2];
            if (type.getValue() == value) {
                toReturn = type;
                break;
            }
            ++n2;
        }
        return toReturn;
    }
}

