/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.enums;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;

public enum ModificationType {
    NEW("New", 1),
    MODIFIED("Modified", 2),
    DELETED("Deleted", 3),
    MERGED("Merged", 4),
    ARTIFACT_DELETED("Artifact Deleted", 5),
    INTRODUCED("Introduced", 6),
    UNDELETED("Undeleted", 7),
    REPLACED_WITH_VERSION("Replace_with_version", 8),
    DELETED_ON_DESTINATION("Deleted on Destination", 9),
    APPLICABILITY("Applicability", 10);

    private static final Set<ModificationType> ALL_NOT_HARD_DELETED;
    private static final Set<ModificationType> ALL_MOD_TYPES;
    private int value;
    private String displayName;

    static {
        ALL_NOT_HARD_DELETED = new HashSet<ModificationType>();
        ALL_MOD_TYPES = new HashSet<ModificationType>();
    }

    private ModificationType(String displayName, int value) {
        this.displayName = displayName;
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isEdited() {
        return this == MERGED || this == MODIFIED;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean matches(ModificationType ... modTypes) {
        ModificationType[] modificationTypeArray = modTypes;
        int n = modTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ModificationType modType = modificationTypeArray[n2];
            if (modType == this) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static ModificationType getMod(int value) throws OseeArgumentException {
        ModificationType[] modificationTypeArray = ModificationType.values();
        int n = modificationTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModificationType modtype = modificationTypeArray[n2];
            if (modtype.value == value) {
                return modtype;
            }
            ++n2;
        }
        throw new OseeArgumentException("[%s] does not correspond to any defined ModificationType enumerations", new Object[]{value});
    }

    public boolean isDeleted() {
        return this == DELETED || this == ARTIFACT_DELETED;
    }

    public boolean isUnDeleted() {
        return this == UNDELETED;
    }

    public boolean isArtifactDeleted() {
        return this == ARTIFACT_DELETED;
    }

    public boolean isHardDeleted() {
        return this == DELETED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<ModificationType> getAllNotHardDeletedTypes() {
        if (ALL_NOT_HARD_DELETED.isEmpty()) {
            Set<ModificationType> set = ALL_NOT_HARD_DELETED;
            synchronized (set) {
                ALL_NOT_HARD_DELETED.addAll(ModificationType.getAllModTypes());
                ALL_NOT_HARD_DELETED.remove((Object)DELETED);
            }
        }
        return ALL_NOT_HARD_DELETED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<ModificationType> getAllModTypes() {
        if (ALL_MOD_TYPES.isEmpty()) {
            Set<ModificationType> set = ALL_MOD_TYPES;
            synchronized (set) {
                ALL_MOD_TYPES.addAll(Arrays.asList(ModificationType.values()));
            }
        }
        return ALL_MOD_TYPES;
    }

    public boolean isExistingVersionUsed() {
        boolean result = false;
        switch (this) {
            case DELETED: 
            case ARTIFACT_DELETED: 
            case INTRODUCED: 
            case REPLACED_WITH_VERSION: {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }
}

