/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.enums;

public enum BranchType {
    WORKING(0),
    BASELINE(2),
    MERGE(3),
    SYSTEM_ROOT(4),
    PORT(5);

    private final int value;

    private BranchType(int value) {
        this.value = value;
    }

    public final int getValue() {
        return this.value;
    }

    public boolean isBaselineBranch() {
        return this == BASELINE;
    }

    public boolean isSystemRootBranch() {
        return this == SYSTEM_ROOT;
    }

    public boolean isMergeBranch() {
        return this == MERGE;
    }

    public boolean isWorkingBranch() {
        return this == WORKING;
    }

    public boolean isPortBranch() {
        return this == PORT;
    }

    public boolean isOfType(BranchType ... branchTypes) {
        BranchType[] branchTypeArray = branchTypes;
        int n = branchTypes.length;
        int n2 = 0;
        while (n2 < n) {
            BranchType branchType = branchTypeArray[n2];
            if (this == branchType) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static BranchType valueOf(String string) {
        return Enum.valueOf(BranchType.class, string);
    }
}

