/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.enums;

public enum BranchState {
    CREATED(0),
    MODIFIED(1),
    COMMITTED(2),
    REBASELINED(3),
    DELETED(4),
    REBASELINE_IN_PROGRESS(5),
    COMMIT_IN_PROGRESS(6),
    CREATION_IN_PROGRESS(7),
    DELETE_IN_PROGRESS(8),
    PURGE_IN_PROGRESS(9),
    PURGED(10);

    private final int value;

    private BranchState(int value) {
        this.value = value;
    }

    public final int getValue() {
        return this.value;
    }

    public boolean isCommitInProgress() {
        return this == COMMIT_IN_PROGRESS;
    }

    public boolean isCreated() {
        return this == CREATED;
    }

    public boolean isModified() {
        return this == MODIFIED;
    }

    public boolean isCommitted() {
        return this == COMMITTED;
    }

    public boolean isRebaselined() {
        return this == REBASELINED;
    }

    public boolean isRebaselineInProgress() {
        return this == REBASELINE_IN_PROGRESS;
    }

    public boolean isCreationInProgress() {
        return this == CREATION_IN_PROGRESS;
    }

    public boolean isDeleted() {
        return this == DELETED;
    }

    public boolean isPurged() {
        return this == PURGED;
    }

    public boolean isDeleteInProgress() {
        return this == DELETE_IN_PROGRESS;
    }

    public boolean isPurgeInProgress() {
        return this == PURGE_IN_PROGRESS;
    }

    public static BranchState getBranchState(int value) {
        BranchState[] branchStateArray = BranchState.values();
        int n = branchStateArray.length;
        int n2 = 0;
        while (n2 < n) {
            BranchState type = branchStateArray[n2];
            if (type.getValue() == value) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    public boolean matches(BranchState ... branchStates) {
        BranchState[] branchStateArray = branchStates;
        int n = branchStates.length;
        int n2 = 0;
        while (n2 < n) {
            BranchState branchState = branchStateArray[n2];
            if (this == branchState) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

