/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.enums;

public enum BranchArchivedState {
    ARCHIVED(1),
    UNARCHIVED(0),
    ALL(-1),
    ARCHIVED_IN_PROGRESS(2),
    UNARCHIVED_IN_PROGRESS(3);

    private final int value;

    private BranchArchivedState(int value) {
        this.value = value;
    }

    public final int getValue() {
        return this.value;
    }

    public boolean isBeingArchived() {
        return this == ARCHIVED_IN_PROGRESS;
    }

    public boolean isBeingUnarchived() {
        return this == UNARCHIVED_IN_PROGRESS;
    }

    public boolean isArchived() {
        return this == ARCHIVED;
    }

    public boolean isUnArchived() {
        return this == UNARCHIVED;
    }

    public boolean matches(BranchArchivedState branchState) {
        return branchState == ALL || this == branchState;
    }

    public static BranchArchivedState fromBoolean(boolean archived) {
        return archived ? ARCHIVED : UNARCHIVED;
    }

    public static BranchArchivedState valueOf(String string) {
        return Enum.valueOf(BranchArchivedState.class, string);
    }
}

