/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public interface UserToken
extends ArtifactToken,
UserId {
    public String getUserId() throws OseeCoreException;

    public boolean isActive() throws OseeCoreException;

    public boolean isAdmin() throws OseeCoreException;

    public String getEmail() throws OseeCoreException;

    public boolean isCreationRequired();

    public static UserToken create(long id, String guid, String name, String email, String userId, boolean active, boolean admin, boolean creationRequired) {
        final class UserTokenImpl
        extends NamedIdBase
        implements UserToken {
            private final String userId;
            private final boolean active;
            private final boolean admin;
            private final String email;
            private final String guid;
            private final boolean creationRequired;

            public UserTokenImpl(long id, String guid, String name, String userId, boolean active, boolean admin, String email, boolean creationRequired) {
                super(Long.valueOf(id), name);
                this.guid = guid;
                this.userId = userId;
                this.active = active;
                this.admin = admin;
                this.email = email;
                this.creationRequired = creationRequired;
            }

            @Override
            public IArtifactType getArtifactType() {
                return CoreArtifactTypes.User;
            }

            @Override
            public String getUserId() {
                return this.userId;
            }

            @Override
            public boolean isActive() {
                return this.active;
            }

            @Override
            public boolean isAdmin() {
                return this.admin;
            }

            @Override
            public String getEmail() {
                return this.email;
            }

            @Override
            public boolean isCreationRequired() {
                return this.creationRequired;
            }

            public String toString() {
                return String.format("UserToken [name [%s], userId=[%s], active=[%s], admin=[%s], email=[%s], creationRequired=[%s]", this.getName(), this.userId, this.active, this.admin, this.email, this.creationRequired);
            }

            public String getGuid() {
                return this.guid;
            }

            @Override
            public BranchId getBranch() {
                return CoreBranches.COMMON;
            }
        }
        return new UserTokenImpl(id, guid, name, userId, active, admin, email, creationRequired);
    }
}

