/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IAccessContextId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;
import org.eclipse.osee.framework.jdk.core.type.NamedIdentity;

public final class TokenFactory {
    public static final Pattern nameIdPattern = Pattern.compile("\\[(.*)\\]-\\[(.*)\\]");

    private TokenFactory() {
    }

    public static IArtifactType createArtifactType(long guid, String name) {
        return new ArtifactTypeToken(guid, name);
    }

    public static IArtifactType createArtifactTypeFromToken(String token) {
        Matcher matcher = nameIdPattern.matcher(token);
        if (matcher.find()) {
            Long uuid = Long.valueOf(matcher.group(2));
            String name = matcher.group(1);
            return new ArtifactTypeToken(uuid, name);
        }
        return null;
    }

    public static RelationTypeToken createRelationType(long id, String name) {
        return RelationTypeToken.create(id, name);
    }

    public static IAccessContextId createAccessContextId(String guid, String name) {
        return new AccessContextIdToken(guid, name);
    }

    public static ArtifactToken createArtifactToken(long id, String guid, String name, IArtifactType artifactType) {
        return ArtifactToken.valueOf(id, guid, name, BranchId.SENTINEL, artifactType);
    }

    public static String createArtifactTypeTokenString(IArtifactType artifactType) {
        return String.format("[%s]-[%d]", artifactType.getName(), artifactType.getGuid());
    }

    private static final class AccessContextIdToken
    extends NamedIdentity<String>
    implements IAccessContextId {
        public AccessContextIdToken(String guid, String name) {
            super((Object)guid, name);
        }

        public String toString() {
            return String.format("%s - %s", this.getName(), this.getGuid());
        }
    }

    private static final class ArtifactTypeToken
    extends NamedIdBase
    implements IArtifactType {
        public ArtifactTypeToken(Long id, String name) {
            super(id, name);
        }

        @Override
        public Long getGuid() {
            return this.getId();
        }
    }
}

