/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import java.io.InputStream;
import java.sql.Timestamp;
import org.eclipse.osee.framework.core.data.OseeClientInfo;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public class OseeSession
extends OseeClientInfo {
    private static final long serialVersionUID = 8144856081780854567L;
    private static final String SESSION_ID = "sessionId";
    private static final String USER_ID = "userId";
    private static final String CREATED_ON = "createdOn";
    private static final String LAST_INTERACTION_DATE = "lastInteractionDate";
    private static final String LAST_INTERACTION = "lastInteraction";

    private OseeSession() {
    }

    public OseeSession(String sessionId, String userId, Timestamp createdOn, String machineName, String machineIp, int port, String clientVersion, Timestamp lastInteractionDate, String lastInteractionName) {
        super(clientVersion, machineName, machineIp, port);
        this.backingData.put(SESSION_ID, sessionId);
        this.backingData.put(USER_ID, userId);
        this.backingData.put(CREATED_ON, createdOn.getTime());
        this.backingData.put(LAST_INTERACTION_DATE, lastInteractionDate.getTime());
        this.backingData.put(LAST_INTERACTION, lastInteractionName);
    }

    public String getUserId() {
        return this.getString(USER_ID);
    }

    public String getSessionId() {
        return this.getString(SESSION_ID);
    }

    public Timestamp getCreation() {
        return new Timestamp(this.backingData.getLong(CREATED_ON));
    }

    public String getLastInteraction() {
        return this.getString(LAST_INTERACTION);
    }

    public Timestamp getLastInteractionDate() {
        return new Timestamp(this.backingData.getLong(LAST_INTERACTION_DATE));
    }

    public void setLastInteraction(String lastInteractionName) {
        this.backingData.put(LAST_INTERACTION, lastInteractionName);
    }

    public void setLastInteractionDate(Timestamp timestamp) {
        this.backingData.put(LAST_INTERACTION_DATE, timestamp.getTime());
    }

    public String getSessionIdAndVersion() {
        return String.format("%s - %s", this.getSessionId(), this.getVersion());
    }

    public static OseeSession fromXml(InputStream inputStream) throws OseeCoreException {
        OseeSession session = new OseeSession();
        session.loadfromXml(inputStream);
        return session;
    }
}

