/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.Named;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public interface IOseeBranch
extends BranchId,
Named {
    public static final int SHORT_NAME_LIMIT = 35;
    public static final IOseeBranch SENTINEL = IOseeBranch.create(Id.SENTINEL, "SENTINEL");

    default public String getShortName() {
        return this.getShortName(35);
    }

    default public String getShortName(int length) {
        return Strings.truncate((String)this.getName(), (int)length);
    }

    public static IOseeBranch create(String name) {
        return IOseeBranch.create(Lib.generateUuid(), name);
    }

    public static IOseeBranch create(BranchId id, String name) {
        return IOseeBranch.create(id.getId(), name, ArtifactId.SENTINEL);
    }

    public static IOseeBranch create(long id, String name) {
        return IOseeBranch.create(id, name, ArtifactId.SENTINEL);
    }

    public static IOseeBranch create(Long id, String name, ArtifactId viewId) {
        final class BranchTokenImpl
        extends NamedIdBase
        implements IOseeBranch {
            private final ArtifactId viewId;

            public BranchTokenImpl(Long id, String name, ArtifactId viewId) {
                super(id, name);
                this.viewId = viewId;
            }

            @Override
            public ArtifactId getViewId() {
                return this.viewId;
            }

            public boolean equals(Object obj) {
                if (obj instanceof BranchId) {
                    return super.equals(obj) && this.viewId.equals(((BranchId)obj).getViewId());
                }
                return false;
            }

            public String toStringWithId() {
                return String.format("[%s]-[%s]", this.getName(), this.getId());
            }
        }
        return new BranchTokenImpl(id, name, viewId);
    }

    public static IOseeBranch create(Long id, String name) {
        return IOseeBranch.create(id, name, ArtifactId.SENTINEL);
    }
}

