/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Properties;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.framework.jdk.core.type.PropertyStoreWriter;

public class BaseExchangeData
implements Serializable {
    private static final long serialVersionUID = -3844333805269321833L;
    protected final PropertyStore backingData = new PropertyStore(Integer.toString(this.hashCode()));

    protected String getString(String key) {
        return this.backingData.get(key);
    }

    protected void loadfromXml(InputStream inputStream) throws OseeCoreException {
        try {
            PropertyStoreWriter writer = new PropertyStoreWriter();
            writer.load(this.backingData, inputStream);
        }
        catch (Exception ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
    }

    public void write(OutputStream outputStream) throws OseeCoreException {
        try {
            PropertyStoreWriter writer = new PropertyStoreWriter();
            writer.save(this.backingData, outputStream);
        }
        catch (Exception ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
    }

    public String toString() {
        return this.backingData.toString();
    }

    protected void putProperties(String fieldName, Properties properties) {
        for (String theKey : properties.stringPropertyNames()) {
            String keyStr = String.format("%s.%s", fieldName, theKey);
            this.backingData.put(keyStr, properties.getProperty(theKey));
        }
    }

    protected Properties getPropertyString(String fieldName) {
        String prefix = String.valueOf(fieldName) + ".";
        Properties toReturn = new Properties();
        for (String key : this.backingData.keySet()) {
            if (!key.startsWith(prefix)) continue;
            String normalizedKey = key.substring(prefix.length(), key.length());
            toReturn.put(normalizedKey, this.backingData.get(key));
        }
        return toReturn;
    }
}

