/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.HasArtifactType;
import org.eclipse.osee.framework.core.data.HasBranch;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.NamedId;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;
import org.eclipse.osee.framework.jdk.core.util.GUID;

public interface ArtifactToken
extends ArtifactId,
HasArtifactType,
HasBranch,
NamedId {
    default public ArtifactTypeId getArtifactTypeId() {
        return null;
    }

    public static ArtifactToken valueOf(Id id, BranchId branch) {
        return ArtifactToken.valueOf(id.getId(), GUID.create(), null, branch, null);
    }

    public static ArtifactToken valueOf(ArtifactId id, BranchId branch) {
        return ArtifactToken.valueOf(id.getId(), GUID.create(), null, branch, null);
    }

    public static ArtifactToken valueOf(long id, BranchId branch) {
        return ArtifactToken.valueOf(id, GUID.create(), null, branch, null);
    }

    public static ArtifactToken valueOf(long id, String name, BranchId branch) {
        return ArtifactToken.valueOf(id, GUID.create(), name, branch, null);
    }

    public static ArtifactToken valueOf(long id, String name, BranchId branch, IArtifactType artifactType) {
        return ArtifactToken.valueOf(id, GUID.create(), name, branch, artifactType);
    }

    public static ArtifactToken valueOf(long id, String guid, String name, BranchId branch, IArtifactType artifactType) {
        final class ArtifactTokenImpl
        extends NamedIdBase
        implements ArtifactToken {
            private final BranchId branch;
            private final IArtifactType artifactType;
            private final String guid;

            public ArtifactTokenImpl(Long id, String guid, String name, BranchId branch, IArtifactType artifactType) {
                super(id, name);
                this.branch = branch;
                this.artifactType = artifactType;
                this.guid = guid;
            }

            @Override
            public IArtifactType getArtifactType() {
                return this.artifactType;
            }

            @Override
            public BranchId getBranch() {
                return this.branch;
            }

            public String getGuid() {
                return this.guid;
            }

            @Override
            public Long getUuid() {
                return this.getId();
            }

            public boolean equals(Object obj) {
                boolean equal = super.equals(obj);
                if (equal && obj instanceof HasBranch) {
                    return this.isOnSameBranch((HasBranch)obj);
                }
                return equal;
            }
        }
        return new ArtifactTokenImpl(id, guid, name, branch, artifactType);
    }
}

