/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.report.internal.wordupdate;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.osee.define.report.api.WordArtifactChange;
import org.eclipse.osee.define.report.api.WordUpdateChange;
import org.eclipse.osee.define.report.api.WordUpdateData;
import org.eclipse.osee.define.report.internal.wordupdate.IElementExtractor;
import org.eclipse.osee.define.report.internal.wordupdate.LinkType;
import org.eclipse.osee.define.report.internal.wordupdate.MergeEditArtifactElementExtractor;
import org.eclipse.osee.define.report.internal.wordupdate.WordExtractorData;
import org.eclipse.osee.define.report.internal.wordupdate.WordImageArtifactElementExtractor;
import org.eclipse.osee.define.report.internal.wordupdate.WordMLApplicabilityHandler;
import org.eclipse.osee.define.report.internal.wordupdate.WordMlLinkHandler;
import org.eclipse.osee.define.report.internal.wordupdate.WordUtilities;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.FeatureDefinitionData;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.util.WordCoreUtil;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.xml.Jaxp;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.BranchReadable;
import org.eclipse.osee.orcs.data.TransactionReadable;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.eclipse.osee.orcs.transaction.TransactionFactory;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class WordUpdateArtifact {
    private final OrcsApi orcsApi;
    private final QueryFactory queryFactory;
    private final Log logger;
    private final EventAdmin eventAdmin;

    public WordUpdateArtifact(Log logger, OrcsApi orcsApi, EventAdmin eventAdmin) {
        this.orcsApi = orcsApi;
        this.queryFactory = orcsApi.getQueryFactory();
        this.logger = logger;
        this.eventAdmin = eventAdmin;
    }

    public WordUpdateChange updateArtifacts(WordUpdateData data) {
        Element oleDataElement;
        Collection<WordExtractorData> extractorDatas;
        try {
            IElementExtractor elementExtractor;
            Document document = this.extractJaxpDocument(data);
            if (data.isThreeWayMerge()) {
                String guid = (String)((ArtifactReadable)((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch(data.getBranch()).andUuid(((Long)data.getArtifacts().iterator().next()).longValue())).getResults().getAtMostOneOrNull()).getGuid();
                elementExtractor = new MergeEditArtifactElementExtractor(guid, document);
            } else {
                elementExtractor = new WordImageArtifactElementExtractor(document);
            }
            extractorDatas = elementExtractor.extractElements();
            oleDataElement = elementExtractor.getOleDataElement();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
        return this.wordArtifactUpdate(data, extractorDatas, oleDataElement);
    }

    public ArtifactReadable getArtifact(BranchId branch, String guid) {
        return (ArtifactReadable)((QueryBuilder)this.queryFactory.fromBranch(branch).andGuid(guid)).getResults().getExactlyOne();
    }

    private Document extractJaxpDocument(WordUpdateData data) throws ParserConfigurationException, SAXException, IOException {
        Document document;
        try (ByteArrayInputStream stream = new ByteArrayInputStream(data.getWordData());){
            document = Jaxp.nonDeferredReadXmlDocument((InputStream)stream, (String)"UTF-8");
        }
        return document;
    }

    private WordUpdateChange wordArtifactUpdate(WordUpdateData data, Collection<WordExtractorData> extractorDatas, Element oleDataElement) {
        ArrayList deletedArtifacts = Lists.newArrayList();
        WordUpdateChange updateChange = new WordUpdateChange();
        try {
            try {
                TransactionFactory txFactory = this.orcsApi.getTransactionFactory();
                boolean singleArtifact = extractorDatas.size() == 1;
                boolean containsOleData = false;
                boolean containsWordData = false;
                ArtifactId account = ArtifactId.valueOf((long)data.getUserArtId());
                TransactionBuilder txBuilder = txFactory.createTransaction(data.getBranch(), account, data.getComment());
                for (WordExtractorData extractorData : extractorDatas) {
                    boolean multiSave;
                    ArtifactReadable artifact = this.getArtifact(data.getBranch(), extractorData.getGuid());
                    WordArtifactChange artChange = new WordArtifactChange();
                    artChange.setArtId(artifact.getId().longValue());
                    if (artifact.isDeleted()) {
                        deletedArtifacts.add(artifact.getName());
                        continue;
                    }
                    containsOleData = artifact.getAttributeCount((AttributeTypeId)CoreAttributeTypes.WordOleData) > 0;
                    boolean bl = containsWordData = artifact.getAttributeCount((AttributeTypeId)CoreAttributeTypes.WordTemplateContent) > 0;
                    if (oleDataElement == null && containsOleData) {
                        txBuilder.setSoleAttributeFromString((ArtifactId)artifact, (AttributeTypeId)CoreAttributeTypes.WordOleData, "");
                        artChange.setChanged(true);
                        artChange.addChangedAttributeType((AttributeTypeId)CoreAttributeTypes.WordOleData);
                    } else if (oleDataElement != null && singleArtifact) {
                        txBuilder.setSoleAttributeFromStream((ArtifactId)artifact, (AttributeTypeId)CoreAttributeTypes.WordOleData, (InputStream)new ByteArrayInputStream(WordUtilities.getFormattedContent(oleDataElement)));
                        artChange.setChanged(true);
                        if (!containsOleData) {
                            artChange.setCreated(true);
                        }
                        artChange.addChangedAttributeType((AttributeTypeId)CoreAttributeTypes.WordOleData);
                    }
                    String content = Lib.inputStreamToString((InputStream)new ByteArrayInputStream(WordUtilities.getFormattedContent(extractorData.getParentEelement())));
                    boolean hasTrackedChanges = WordCoreUtil.containsWordAnnotations((String)content);
                    HashCollection<String, String> validFeatureValues = this.getValidFeatureValuesForBranch(data.getBranch());
                    HashSet<String> validConfigurations = this.getValidConfigurations(data.getBranch());
                    boolean hasInvalidApplicabilityTags = WordCoreUtil.areApplicabilityTagsInvalid((String)content, (BranchId)data.getBranch(), validFeatureValues, validConfigurations);
                    boolean bl2 = multiSave = data.isMultiEdit() || this.hasChangedContent(artifact, content);
                    if (singleArtifact || multiSave) {
                        if (!hasTrackedChanges) {
                            if (extractorData.getParentEelement().getNodeName().endsWith("body")) {
                                content = content.replace("<w:pPr><w:rPr><w:vanish/></w:rPr></w:pPr>", "");
                            }
                            LinkType linkType = LinkType.OSEE_SERVER_LINK;
                            content = WordMlLinkHandler.unlink(this.queryFactory, linkType, artifact, content);
                            txBuilder.setSoleAttributeValue((ArtifactId)artifact, (AttributeTypeId)CoreAttributeTypes.WordTemplateContent, (Object)content);
                            artChange.setChanged(true);
                            if (!containsWordData) {
                                artChange.setCreated(true);
                            }
                            artChange.addChangedAttributeType((AttributeTypeId)CoreAttributeTypes.WordTemplateContent);
                            if (hasInvalidApplicabilityTags) {
                                updateChange.setInvalidApplicabilityTagArts(artifact.getId(), artifact.getName());
                            }
                        } else {
                            if (hasTrackedChanges) {
                                updateChange.setTrackedChangeArts(artifact.getId(), artifact.getName());
                            }
                            if (hasInvalidApplicabilityTags) {
                                updateChange.setInvalidApplicabilityTagArts(artifact.getId(), artifact.getName());
                            }
                        }
                    }
                    if (!artChange.isChanged()) continue;
                    artChange.setSafetyRelated(this.checkIfSafetyRelated(artifact, (AttributeTypeId)CoreAttributeTypes.LegacyDAL) || this.checkIfSafetyRelated(artifact, (AttributeTypeId)CoreAttributeTypes.ItemDAL));
                    updateChange.addChangedArt(artChange);
                    artChange.addChangedAttributeType((AttributeTypeId)CoreAttributeTypes.WordTemplateContent);
                }
                TransactionReadable tx = txBuilder.commit();
                if (tx != null) {
                    this.postProcessChange(tx, updateChange, account);
                }
            }
            catch (Exception ex) {
                throw OseeCoreException.wrap((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            if (!deletedArtifacts.isEmpty()) {
                throw new OseeStateException("The following deleted artifacts could not be saved [%s]", new Object[]{Collections.toString((String)",", (Iterable)deletedArtifacts)});
            }
            throw throwable;
        }
        if (!deletedArtifacts.isEmpty()) {
            throw new OseeStateException("The following deleted artifacts could not be saved [%s]", new Object[]{Collections.toString((String)",", (Iterable)deletedArtifacts)});
        }
        return updateChange;
    }

    private void postProcessChange(TransactionReadable tx, WordUpdateChange updateChange, ArtifactId account) {
        updateChange.setTx((TransactionId)tx);
        updateChange.setBranch(tx.getBranch());
        if (updateChange.hasSafetyRelatedArtifactChange()) {
            try {
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("org/eclipse/osee/define/report/internal/BRANCH_ID", tx.getBranch());
                properties.put("org/eclipse/osee/define/report/internal/USER_ART", account);
                Event event = new Event("org/eclipse/osee/define/safetyworkflow/modified", properties);
                this.eventAdmin.postEvent(event);
            }
            catch (Exception ex) {
                this.logger.error((Throwable)ex, "Could not create safety workflow", new Object[0]);
            }
        }
    }

    private boolean hasChangedContent(ArtifactReadable artifact, String content) {
        String originalContent = artifact.getSoleAttributeAsString((AttributeTypeId)CoreAttributeTypes.WordTemplateContent, "");
        return !WordUtilities.textOnly(originalContent).equals(WordUtilities.textOnly(content)) || !WordUtilities.referencesOnly(originalContent).equals(WordUtilities.referencesOnly(content));
    }

    private boolean checkIfSafetyRelated(ArtifactReadable artifact, AttributeTypeId dalAttrType) {
        String dal = artifact.getSoleAttributeAsString(dalAttrType, "");
        return "A".equals(dal) || "B".equals(dal) || "C".equals(dal);
    }

    private HashCollection<String, String> getValidFeatureValuesForBranch(BranchId branch) {
        BranchReadable br = (BranchReadable)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(branch)).getResults().getOneOrNull();
        if (br.getBranchType().equals((Object)BranchType.MERGE)) {
            branch = br.getParentBranch();
        }
        List featureDefinitionArts = ((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeId[]{CoreArtifactTypes.FeatureDefinition})).getResults().getList();
        List featureDefinitionData = this.orcsApi.getQueryFactory().applicabilityQuery().getFeatureDefinitionData(featureDefinitionArts);
        HashCollection validFeatureValues = new HashCollection();
        for (FeatureDefinitionData feat : featureDefinitionData) {
            validFeatureValues.put((Object)feat.getName().toUpperCase(), (Collection)feat.getValues());
        }
        return validFeatureValues;
    }

    private HashSet<String> getValidConfigurations(BranchId branch) {
        BranchReadable br = (BranchReadable)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(branch)).getResults().getOneOrNull();
        if (br.getBranchType().equals((Object)BranchType.MERGE)) {
            branch = br.getParentBranch();
        }
        return WordMLApplicabilityHandler.getValidConfigurations(this.orcsApi, branch);
    }
}

