/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.report.internal.wordupdate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.define.report.internal.wordupdate.LinkType;
import org.eclipse.osee.define.report.internal.wordupdate.OseeLinkBuilder;
import org.eclipse.osee.define.report.internal.wordupdate.OseeLinkParser;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.jdk.core.text.change.ChangeSet;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.BranchReadable;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.search.QueryFactory;

public class WordMlLinkHandler {
    private static final Matcher OSEE_LINK_PATTERN = Pattern.compile("OSEE_LINK\\((.*?)\\)", 32).matcher("");
    private static final Matcher WORDML_LINK = Pattern.compile("<w:hlink\\s+w:dest=\"(.*?)\"[^>]*?(/>|>.*?</w:hlink\\s*>)", 32).matcher("");
    private static final Matcher HYPERLINK_PATTERN = Pattern.compile("<w:r[^>]*><w:instrText>\\s*HYPERLINK\\s+\"(.+?)\"\\s*</w:instrText></w:r>(.*?</w:t>.+?</w:fldChar></w:r>)?", 32).matcher("");
    public static final String WORDML_KEY = "wordml";
    public static final String UNKNOWNGUIDS_KEY = "unknownguids";
    private static final OseeLinkBuilder linkBuilder = new OseeLinkBuilder();

    private static LinkType checkLinkType(LinkType value) {
        return value != null ? value : LinkType.OSEE_SERVER_LINK;
    }

    public static String unlink(QueryFactory queryFactory, LinkType sourceLinkType, ArtifactReadable source, String content) throws OseeCoreException {
        LinkType linkType = WordMlLinkHandler.checkLinkType(sourceLinkType);
        String modified = content;
        HashCollection<String, MatchRange> matchMap = WordMlLinkHandler.parseOseeWordMLLinks(content);
        if (!matchMap.isEmpty()) {
            modified = WordMlLinkHandler.modifiedContent(queryFactory, linkType, source, content, matchMap, true, TransactionId.SENTINEL, null, null, null, null);
        }
        return modified;
    }

    public static String link(QueryFactory queryFactory, LinkType destLinkType, ArtifactReadable source, String content, TransactionId txId, String sessionId, Set<String> unknownGuids, PresentationType presentationType, String permanentUrl) throws OseeCoreException {
        LinkType linkType = WordMlLinkHandler.checkLinkType(destLinkType);
        String modified = content;
        HashCollection<String, MatchRange> matchMap = WordMlLinkHandler.parseOseeWordMLLinks(content);
        OSEE_LINK_PATTERN.reset(content);
        while (OSEE_LINK_PATTERN.find()) {
            String guid = OSEE_LINK_PATTERN.group(1);
            if (!Strings.isValid((String)guid)) continue;
            matchMap.put((Object)guid, (Object)new MatchRange(OSEE_LINK_PATTERN.start(), OSEE_LINK_PATTERN.end()));
        }
        OSEE_LINK_PATTERN.reset();
        if (!matchMap.isEmpty()) {
            modified = WordMlLinkHandler.modifiedContent(queryFactory, linkType, source, content, matchMap, false, txId, sessionId, unknownGuids, presentationType, permanentUrl);
        }
        if (linkType != LinkType.OSEE_SERVER_LINK) {
            modified = String.valueOf(linkBuilder.getWordMlBookmark(source)) + modified;
        }
        return modified;
    }

    public static HashCollection<String, MatchRange> parseOseeWordMLLinks(String content) throws OseeCoreException {
        String guid;
        String link;
        HashCollection matchMap = new HashCollection();
        OseeLinkParser linkParser = new OseeLinkParser();
        WORDML_LINK.reset(content);
        while (WORDML_LINK.find()) {
            link = WORDML_LINK.group(1);
            if (!Strings.isValid((String)link)) continue;
            linkParser.parse(link);
            guid = linkParser.getGuid();
            if (!Strings.isValid((String)guid)) continue;
            matchMap.put((Object)guid, (Object)new MatchRange(WORDML_LINK.start(), WORDML_LINK.end()));
        }
        WORDML_LINK.reset();
        HYPERLINK_PATTERN.reset(content);
        while (HYPERLINK_PATTERN.find()) {
            link = HYPERLINK_PATTERN.group(1);
            if (!Strings.isValid((String)link)) continue;
            linkParser.parse(link);
            guid = linkParser.getGuid();
            if (!Strings.isValid((String)guid)) continue;
            matchMap.put((Object)guid, (Object)new MatchRange(HYPERLINK_PATTERN.start(), HYPERLINK_PATTERN.end()));
        }
        HYPERLINK_PATTERN.reset();
        return matchMap;
    }

    private static List<ArtifactReadable> findArtifacts(QueryFactory queryFactory, BranchId branch, List<String> guidsFromLinks, TransactionId txId) throws OseeCoreException {
        LinkedList arts = Lists.newLinkedList();
        if (txId.isValid()) {
            arts.addAll(((QueryBuilder)((QueryBuilder)((QueryBuilder)((QueryBuilder)queryFactory.fromBranch(branch).fromTransaction(txId)).andGuids(guidsFromLinks)).includeDeletedArtifacts()).includeDeletedAttributes()).getResults().getList());
        } else {
            arts.addAll(((QueryBuilder)((QueryBuilder)((QueryBuilder)queryFactory.fromBranch(branch).andGuids(guidsFromLinks)).includeDeletedArtifacts()).includeDeletedAttributes()).getResults().getList());
        }
        return arts;
    }

    private static List<String> getGuidsNotFound(List<String> guidsFromLinks, List<ArtifactReadable> artifactsFound) {
        HashSet<String> artGuids = new HashSet<String>();
        for (ArtifactReadable artifact : artifactsFound) {
            artGuids.add((String)artifact.getGuid());
        }
        return Collections.setComplement(guidsFromLinks, artGuids);
    }

    private static String modifiedContent(QueryFactory queryFactory, LinkType destLinkType, ArtifactReadable source, String original, HashCollection<String, MatchRange> matchMap, boolean isUnliking, TransactionId txId, String sessionId, Set<String> unknown, PresentationType presentationType, String permanentUrl) throws OseeCoreException {
        boolean isMergeBranch;
        BranchId branch = source.getBranch();
        ChangeSet changeSet = new ChangeSet((CharSequence)original);
        Object artifactsFromSearch = null;
        ArrayList<String> guidsFromLinks = new ArrayList<String>(matchMap.keySet());
        artifactsFromSearch = WordMlLinkHandler.findArtifacts(queryFactory, branch, guidsFromLinks, txId);
        boolean bl = isMergeBranch = ((BranchQuery)((BranchQuery)queryFactory.branchQuery().andId(branch)).andIsOfType(new BranchType[]{BranchType.MERGE})).getCount() > 0;
        if (guidsFromLinks.size() != artifactsFromSearch.size() && isMergeBranch) {
            BranchReadable branchReadable = (BranchReadable)((BranchQuery)queryFactory.branchQuery().andId(branch)).getResults().getExactlyOne();
            List<String> unknownGuids = WordMlLinkHandler.getGuidsNotFound(guidsFromLinks, artifactsFromSearch);
            Iterator<String> union = new ArrayList();
            union.addAll(WordMlLinkHandler.findArtifacts(queryFactory, branchReadable.getParentBranch(), unknownGuids, txId));
            union.addAll((Collection<String>)artifactsFromSearch);
            artifactsFromSearch = union;
        }
        if (guidsFromLinks.size() != artifactsFromSearch.size()) {
            List<String> unknownGuids = WordMlLinkHandler.getGuidsNotFound(guidsFromLinks, artifactsFromSearch);
            if (isUnliking) {
                for (String guid : unknownGuids) {
                    Collection matches = matchMap.getValues((Object)guid);
                    for (Object match : matches) {
                        String replaceWith = linkBuilder.getOseeLinkMarker(guid);
                        changeSet.replace(((MatchRange)match).start(), ((MatchRange)match).end(), replaceWith);
                    }
                }
            } else if (!unknownGuids.isEmpty()) {
                unknown.addAll(unknownGuids);
                for (String guid : unknownGuids) {
                    for (MatchRange match : matchMap.getValues((Object)guid)) {
                        String link = linkBuilder.getUnknownArtifactLink(guid, branch);
                        changeSet.replace(match.start(), match.end(), link);
                    }
                }
            }
        }
        Iterator<ArtifactReadable> iterator = artifactsFromSearch.iterator();
        while (iterator.hasNext()) {
            ArtifactReadable artifact = iterator.next();
            for (MatchRange match : matchMap.getValues((Object)((String)artifact.getGuid()))) {
                String replaceWith = null;
                replaceWith = isUnliking ? linkBuilder.getOseeLinkMarker((String)artifact.getGuid()) : linkBuilder.getWordMlLink(destLinkType, artifact, txId, sessionId, presentationType, permanentUrl);
                changeSet.replace(match.start(), match.end(), replaceWith);
            }
        }
        return changeSet.applyChangesToSelf().toString();
    }

    public static final class MatchRange {
        private final int start;
        private final int end;

        public MatchRange(int start, int end) {
            this.end = end;
            this.start = start;
        }

        public int start() {
            return this.start;
        }

        public int end() {
            return this.end;
        }

        public String toString() {
            return "{" + this.start + ", " + this.end + "}";
        }
    }
}

