/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.report.internal;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.define.report.AlternateTypeOutput;
import org.eclipse.osee.define.report.TraceReportGenerator;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ISheetWriter;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;

public class TraceInformationAccumulator {
    private final ISheetWriter traceWriter;
    private final TraceReportGenerator traceReport;
    private List<ArtifactReadable> softwareRequirements = null;
    private List<ArtifactReadable> components = null;
    private List<ArtifactReadable> tests = null;
    private List<ArtifactReadable> testPlans = null;

    public TraceInformationAccumulator(TraceReportGenerator TraceReportGenerator2, ISheetWriter providedWriter) {
        this.traceReport = TraceReportGenerator2;
        this.traceWriter = providedWriter;
    }

    public void outputSubsystemsRequirementsMap(ArtifactReadable systemReqt, ISheetWriter writer) throws IOException {
        this.softwareRequirements = systemReqt.getRelated(CoreRelationTypes.Requirement_Trace__Lower_Level).getList();
        if (this.outputReqts() == 0) {
            writer.endRow();
        }
    }

    public void outputSubsystemsComponentsMap(ArtifactReadable systemReqt, ISheetWriter writer) throws IOException {
        this.components = systemReqt.getRelated(CoreRelationTypes.Allocation__Component).getList();
        if (this.outputItems(this.components) == 0) {
            writer.endRow();
        }
    }

    public void outputSubsystemsTestsMap(ArtifactReadable systemReqt, ISheetWriter writer) throws IOException {
        this.tests = systemReqt.getRelated(CoreRelationTypes.Verification__Verifier).getList();
        if (this.outputItems(this.tests) == 0) {
            writer.endRow();
        }
    }

    public void outputSubsystemsTestPlansMap(ArtifactReadable systemReqt, ISheetWriter writer) throws IOException {
        this.testPlans = systemReqt.getRelated(CoreRelationTypes.Verification_Plan__Test_Plan_Element).getList();
        if (this.outputItems(this.testPlans) == 0) {
            writer.endRow();
        }
    }

    private int outputReqts() throws IOException {
        int count = 0;
        for (ArtifactReadable ar : this.softwareRequirements) {
            this.processSoftwareRequirement(ar);
            this.traceWriter.endRow();
            ++count;
        }
        return count;
    }

    private int outputItems(List<ArtifactReadable> items) throws IOException {
        int count = 0;
        for (ArtifactReadable ar : items) {
            this.traceWriter.writeCell((Object)ar.getName(), TraceReportGenerator.SOFTWARE_SHEETREQ_INDEX);
            this.traceWriter.writeCell((Object)ar.getId());
            this.traceWriter.endRow();
            ++count;
        }
        return count;
    }

    private void processSoftwareRequirement(ArtifactReadable softwareRequirement) throws IOException {
        Collection<String> traceUnits;
        this.traceWriter.writeCell((Object)this.handleEquivalentName(softwareRequirement), TraceReportGenerator.SOFTWARE_REQUIREMENT_INDEX);
        this.traceWriter.writeCell((Object)softwareRequirement.getId());
        this.traceWriter.writeCell((Object)softwareRequirement.getSoleAttributeAsString((AttributeTypeId)CoreAttributeTypes.SeverityCategory, "none"));
        int size = 0;
        size = this.processSoftwareReqtSubItem(softwareRequirement, CoreRelationTypes.Allocation__Component, TraceReportGenerator.SOFTWARE_COMPONENT_INDEX);
        size += this.processSoftwareReqtSubItem(softwareRequirement, CoreRelationTypes.Verification__Verifier, TraceReportGenerator.SOFTWARE_PROCEDURE_INDEX);
        size += this.processSoftwareReqtSubItem(softwareRequirement, CoreRelationTypes.Validation__Validator, TraceReportGenerator.SOFTWARE_SCRIPT_INDEX);
        Collection<String> codeUnits = this.traceReport.getRequirementToCodeUnitsValues(softwareRequirement);
        if (Conditions.hasValues(codeUnits)) {
            for (String codeUnit : codeUnits) {
                this.traceWriter.writeCell((Object)codeUnit, TraceReportGenerator.SOFTWARE_CODEUNIT_INDEX);
                this.traceWriter.endRow();
                ++size;
            }
        }
        if (Conditions.hasValues(traceUnits = this.traceReport.getRequirementToTraceUnitsValues(softwareRequirement))) {
            for (String traceUnit : traceUnits) {
                this.traceWriter.writeCell((Object)traceUnit, TraceReportGenerator.SOFTWARE_TRACEUNIT_INDEX);
                this.traceWriter.endRow();
                ++size;
            }
        }
        if (size == 0) {
            this.traceWriter.endRow();
        }
    }

    public String handleEquivalentName(ArtifactReadable softwareRequirement) {
        AttributeTypeId attrType;
        String toReturn = softwareRequirement.getName();
        AlternateTypeOutput alt = this.traceReport.getAlternateRequirementType();
        if (alt != null && softwareRequirement.isOfType(new ArtifactTypeId[]{alt.getAlternateArtifactType()}) && (attrType = alt.getAlternateAttributeType()) != null) {
            toReturn = softwareRequirement.getSoleAttributeAsString(attrType, toReturn);
        }
        return toReturn;
    }

    private int processSoftwareReqtSubItem(ArtifactReadable softwareReqt, RelationTypeSide type, int location) throws IOException {
        List items = softwareReqt.getRelated(type).getList();
        if (items.size() > 0) {
            for (ArtifactReadable ar : items) {
                this.traceWriter.writeCell((Object)ar.getName(), location);
                this.traceWriter.writeCell((Object)ar.getId());
                this.traceWriter.endRow();
            }
        }
        return items.size();
    }

    public String getAttributesToStringList(ArtifactReadable artifact, AttributeTypeId attributeType) {
        StringBuilder items = new StringBuilder();
        boolean first = true;
        for (AttributeReadable attribute : artifact.getAttributes(attributeType)) {
            if (!first) {
                items.append(", ");
            } else {
                first = false;
            }
            items.append(attribute.getDisplayableString());
        }
        return items.toString();
    }
}

