/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.report.internal;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.osee.app.OseeAppletPage;
import org.eclipse.osee.define.report.internal.SafetyStreamingOutput;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.IResourceRegistry;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;

@Path(value="/")
public final class SystemSafetyResource {
    private final OrcsApi orcsApi;
    private final IResourceRegistry resourceRegistry;
    private final Log logger;

    public SystemSafetyResource(Log logger, IResourceRegistry resourceRegistry, OrcsApi orcsApi) {
        this.logger = logger;
        this.resourceRegistry = resourceRegistry;
        this.orcsApi = orcsApi;
    }

    @Path(value="safety")
    @GET
    @Produces(value={"application/xml"})
    public Response getSystemSafetyReport(@QueryParam(value="branch") BranchId branchId, @QueryParam(value="code_root") String codeRoot) {
        SafetyStreamingOutput streamingOutput = new SafetyStreamingOutput(this.logger, this.orcsApi, branchId, codeRoot);
        Response.ResponseBuilder builder = Response.ok((Object)streamingOutput);
        builder.header("Content-Disposition", (Object)"attachment; filename=Safety_Report.xml");
        return builder.build();
    }

    @Path(value="ui/safety")
    @GET
    @Produces(value={"text/html"})
    public String getApplet() {
        OseeAppletPage pageUtil = new OseeAppletPage(this.orcsApi.getQueryFactory().branchQuery());
        return pageUtil.realizeApplet(this.resourceRegistry, "systemSafetyReport.html", this.getClass());
    }
}

