/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.report.internal;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.eclipse.osee.define.report.SafetyReportGenerator;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;

public final class SafetyStreamingOutput
implements StreamingOutput {
    private final OrcsApi orcsApi;
    private final BranchId branchId;
    private final String codeRoot;
    private final Log logger;

    public SafetyStreamingOutput(Log logger, OrcsApi orcsApi, BranchId branchId, String codeRoot) {
        this.logger = logger;
        this.orcsApi = orcsApi;
        this.branchId = branchId;
        this.codeRoot = codeRoot;
    }

    public void write(OutputStream output) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(output);
            SafetyReportGenerator safetyReport = new SafetyReportGenerator(this.logger);
            safetyReport.runOperation(this.orcsApi, this.branchId, this.codeRoot, writer);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }
}

