/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.report.internal;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osee.define.report.SafetyReportGenerator;
import org.eclipse.osee.define.report.internal.SafetyCriticalityLookup;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ISheetWriter;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;

public final class SafetyInformationAccumulator {
    private final ISheetWriter writer;
    private final SafetyReportGenerator safetyReport;
    private String functionalCategory;
    private List<ArtifactReadable> subsystemFunctions;
    private final HashMap<ArtifactReadable, List<ArtifactReadable>> subsystemRequirements = Maps.newHashMap();
    private final HashMap<ArtifactReadable, List<ArtifactReadable>> softwareRequirements = Maps.newHashMap();
    private static final Predicate<ArtifactReadable> notAbstractSoftwareRequirement = new Predicate<ArtifactReadable>(){

        public boolean apply(ArtifactReadable input) {
            boolean toReturn = true;
            try {
                toReturn = !input.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.AbstractSoftwareRequirement});
            }
            catch (OseeCoreException oseeCoreException) {}
            return toReturn;
        }
    };

    public SafetyInformationAccumulator(SafetyReportGenerator providedSafetyReport, ISheetWriter providedWriter) {
        this.safetyReport = providedSafetyReport;
        this.writer = providedWriter;
    }

    public String calculateBoeingEquivalentSWQualLevel(String softwareReqDAL, int partitionCount) {
        String toReturn = "";
        if (this.functionalCategory.equals("IFR/IMC")) {
            toReturn = this.checkLevel(softwareReqDAL) ? (partitionCount > 1 ? "C*" : "C") : "BP";
        } else if (this.functionalCategory.equals("Tactical")) {
            toReturn = "BP";
        }
        return toReturn;
    }

    public void reset(ArtifactReadable systemFunction) {
        this.functionalCategory = systemFunction.getSoleAttributeAsString((AttributeTypeId)CoreAttributeTypes.FunctionalCategory, "");
        this.subsystemRequirements.clear();
        this.softwareRequirements.clear();
    }

    public void buildSubsystemsRequirementsMap(ArtifactReadable systemFunction) {
        this.subsystemFunctions = Lists.newArrayList((Iterable)systemFunction.getRelated(CoreRelationTypes.Dependency__Dependency));
        Iterator<ArtifactReadable> sfIter = this.subsystemFunctions.iterator();
        while (sfIter.hasNext()) {
            ArtifactReadable subsystemFunction = sfIter.next();
            List<ArtifactReadable> localSubsystemRequirements = this.checkSubsystemRequirements(subsystemFunction);
            if (localSubsystemRequirements.isEmpty()) {
                sfIter.remove();
                continue;
            }
            this.subsystemRequirements.put(subsystemFunction, localSubsystemRequirements);
        }
    }

    private List<ArtifactReadable> checkSubsystemRequirements(ArtifactReadable subsystemFunction) {
        ArrayList localSubsystemRequirements = Lists.newArrayList((Iterable)subsystemFunction.getRelated(CoreRelationTypes.Design__Requirement));
        Iterator ssrIter = localSubsystemRequirements.iterator();
        while (ssrIter.hasNext()) {
            ArtifactReadable subsystemRequirement = (ArtifactReadable)ssrIter.next();
            ArrayList localSoftwareRequirements = Lists.newArrayList((Iterable)subsystemRequirement.getRelated(CoreRelationTypes.Requirement_Trace__Lower_Level));
            Iterables.removeIf((Iterable)localSoftwareRequirements, notAbstractSoftwareRequirement);
            if (localSoftwareRequirements.isEmpty()) {
                ssrIter.remove();
                continue;
            }
            this.softwareRequirements.put(subsystemRequirement, localSoftwareRequirements);
        }
        return localSubsystemRequirements;
    }

    public void output() throws IOException {
        for (ArtifactReadable subsystemFunction : this.subsystemFunctions) {
            this.processSubsystemFunction(subsystemFunction);
            this.writer.endRow();
        }
    }

    private boolean checkLevel(String input) {
        boolean toReturn = false;
        if (input.equals("A") || input.equals("B") || input.equals("C")) {
            toReturn = true;
        }
        return toReturn;
    }

    private String convertSafetyCriticalityToDAL(String inputSafetyCriticality) {
        if (inputSafetyCriticality.length() > 4) {
            return "Error";
        }
        return SafetyCriticalityLookup.getDALLevelFromSeverityCategory(inputSafetyCriticality);
    }

    private void processSubsystemFunction(ArtifactReadable subsystemFunction) throws IOException {
        this.writer.writeCell((Object)subsystemFunction.getName(), SafetyReportGenerator.SUBSYSTEM_FUNCTION_INDEX);
        String sevCat = subsystemFunction.getSoleAttributeAsString((AttributeTypeId)CoreAttributeTypes.SeverityCategory, "Error: not available");
        this.writer.writeCell((Object)sevCat);
        this.writer.writeCell((Object)subsystemFunction.getSoleAttributeAsString((AttributeTypeId)CoreAttributeTypes.FunctionalDAL, ""));
        this.writer.writeCell((Object)subsystemFunction.getSoleAttributeAsString((AttributeTypeId)CoreAttributeTypes.FunctionalDALRationale, ""));
        for (ArtifactReadable subsystemRequirement : this.subsystemRequirements.get(subsystemFunction)) {
            this.processSubsystemRequirement(subsystemRequirement, this.convertSafetyCriticalityToDAL(sevCat));
        }
        this.writer.endRow();
    }

    private void processSubsystemRequirement(ArtifactReadable subsystemRequirement, String criticality) throws IOException {
        this.writer.writeCell((Object)subsystemRequirement.getSoleAttributeAsString((AttributeTypeId)CoreAttributeTypes.Subsystem, ""), SafetyReportGenerator.SUBSYSTEM_INDEX);
        this.writer.writeCell(subsystemRequirement.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ParagraphNumber, (Object)""));
        this.writer.writeCell((Object)subsystemRequirement.getName());
        this.writer.writeCell((Object)subsystemRequirement.getSoleAttributeAsString((AttributeTypeId)CoreAttributeTypes.ItemDAL, ""));
        this.writer.writeCell((Object)subsystemRequirement.getSoleAttributeAsString((AttributeTypeId)CoreAttributeTypes.ItemDALRationale, ""));
        String currentCriticality = this.writeCriticalityWithDesignCheck(subsystemRequirement, criticality, (AttributeTypeId)CoreAttributeTypes.ItemDAL, CoreRelationTypes.Design__Design, (AttributeTypeId)CoreAttributeTypes.SeverityCategory);
        for (ArtifactReadable softwareRequirement : this.softwareRequirements.get(subsystemRequirement)) {
            this.processSoftwareRequirement(softwareRequirement, currentCriticality);
        }
        this.writer.endRow();
    }

    private String writeCriticalityWithDesignCheck(ArtifactReadable art, String criticality, AttributeTypeId thisType, RelationTypeSide relType, AttributeTypeId otherType) throws IOException {
        int childValue;
        int parentValue;
        String current = art.getSoleAttributeAsString(thisType, "Error");
        if ("Error".equals(criticality) || "Error".equals(current)) {
            this.writer.writeCell((Object)"Error: invalid content");
            return "Error";
        }
        if ("Unspecified".equals(current)) {
            this.writer.writeCell((Object)"Unspecified");
            return "Unspecified";
        }
        if ("Unspecified".equals(criticality)) {
            criticality = "E";
        }
        if ((parentValue = SafetyCriticalityLookup.getDALLevel(criticality).intValue()) < (childValue = SafetyCriticalityLookup.getDALLevel(current).intValue())) {
            this.writer.writeCell((Object)String.format("%s [Error:<%s]", current, criticality));
        } else {
            this.checkBackTrace(art, childValue, thisType, relType, otherType);
        }
        return current;
    }

    private void checkBackTrace(ArtifactReadable art, Integer current, AttributeTypeId thisType, RelationTypeSide relType, AttributeTypeId otherType) throws IOException {
        ArrayList tracedToRequirements = Lists.newArrayList((Iterable)art.getRelated(relType));
        int maxCritVal = 4;
        int parentCritVal = 4;
        for (ArtifactReadable parent : tracedToRequirements) {
            String intermediate;
            if (otherType.equals(CoreAttributeTypes.SeverityCategory)) {
                intermediate = parent.getSoleAttributeAsString(otherType, "NH");
                if ("Unspecified".equals(intermediate)) {
                    intermediate = "NH";
                }
                parentCritVal = SafetyCriticalityLookup.getSeverityLevel(intermediate);
            } else if (otherType.equals(CoreAttributeTypes.ItemDAL)) {
                intermediate = parent.getSoleAttributeAsString(otherType, "E");
                if ("Unspecified".equals(intermediate)) {
                    intermediate = "E";
                }
                parentCritVal = SafetyCriticalityLookup.getDALLevel(intermediate);
            } else {
                throw new OseeArgumentException("Invalid attribute type: %s", new Object[]{otherType.toString()});
            }
            maxCritVal = Integer.min(maxCritVal, parentCritVal);
        }
        if (current < maxCritVal) {
            this.writer.writeCell((Object)String.format("%s [Error:<%s]", SafetyCriticalityLookup.getDALLevelFromInt(current), SafetyCriticalityLookup.getDALLevelFromInt(maxCritVal)));
        } else {
            this.writer.writeCell((Object)SafetyCriticalityLookup.getDALLevelFromInt(current));
        }
    }

    private void processSoftwareRequirement(ArtifactReadable softwareRequirement, String sevCat) throws IOException {
        this.writer.writeCell((Object)softwareRequirement.getName(), SafetyReportGenerator.SOFTWARE_REQUIREMENT_INDEX);
        String softwareRequirementDAL = this.writeCriticalityWithDesignCheck(softwareRequirement, sevCat, (AttributeTypeId)CoreAttributeTypes.ItemDAL, CoreRelationTypes.Requirement_Trace__Higher_Level, (AttributeTypeId)CoreAttributeTypes.ItemDAL);
        this.writer.writeCell((Object)softwareRequirement.getSoleAttributeAsString((AttributeTypeId)CoreAttributeTypes.ItemDALRationale, ""));
        this.writer.writeCell((Object)softwareRequirement.getSoleAttributeAsString((AttributeTypeId)CoreAttributeTypes.SoftwareControlCategory, ""));
        this.writer.writeCell((Object)softwareRequirement.getSoleAttributeAsString((AttributeTypeId)CoreAttributeTypes.SoftwareControlCategoryRationale, ""));
        this.writer.writeCell((Object)this.calculateBoeingEquivalentSWQualLevel(softwareRequirementDAL, softwareRequirement.getAttributeCount((AttributeTypeId)CoreAttributeTypes.Partition)));
        this.writer.writeCell((Object)this.functionalCategory);
        this.writer.writeCell((Object)Collections.toString((String)",", this.getAttributesToStringList(softwareRequirement, (AttributeTypeId)CoreAttributeTypes.Partition)));
        this.writer.writeCell((Object)this.safetyReport.getComponentUtil().getQualifiedComponentNames(softwareRequirement));
        Collection<String> codeUnits = this.safetyReport.getRequirementToCodeUnitsValues(softwareRequirement);
        if (Conditions.hasValues(codeUnits)) {
            for (String codeUnit : codeUnits) {
                this.writer.writeCell((Object)codeUnit, SafetyReportGenerator.CODE_UNIT_INDEX);
                this.writer.endRow();
            }
        } else {
            this.writer.endRow();
        }
    }

    public List<String> getAttributesToStringList(ArtifactReadable artifact, AttributeTypeId attributeType) {
        ArrayList<String> items = new ArrayList<String>();
        for (AttributeReadable attribute : artifact.getAttributes(attributeType)) {
            items.add(attribute.getDisplayableString());
        }
        return items;
    }
}

