/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.report.internal;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;

public class SafetyCriticalityLookup {
    private static final String[][] criticalityMap = new String[][]{{"A", "A", "C", "D", "E"}, {"A", "B", "C", "D", "E"}, {"B", "C", "D", "D", "E"}, {"C", "D", "D", "D", "E"}, {"E", "E", "E", "E", "E"}};
    private static final Map<String, Integer> controlCategoryMap = ImmutableMap.of((Object)"1(AT)", (Object)0, (Object)"2(SAT)", (Object)1, (Object)"3(RFT)", (Object)2, (Object)"4(IN)", (Object)3, (Object)"5(NSI)", (Object)4);
    private static final Map<String, Integer> severityCategoryMap = ImmutableMap.of((Object)"I", (Object)0, (Object)"II", (Object)1, (Object)"III", (Object)2, (Object)"IV", (Object)3, (Object)"NH", (Object)4);
    private static final Map<String, Integer> DALCategoryMap = ImmutableMap.of((Object)"A", (Object)0, (Object)"B", (Object)1, (Object)"C", (Object)2, (Object)"D", (Object)3, (Object)"E", (Object)4);
    private static final Map<String, String> safetyCriticalityMap = ImmutableMap.of((Object)"I", (Object)"A", (Object)"II", (Object)"B", (Object)"III", (Object)"C", (Object)"IV", (Object)"D", (Object)"NH", (Object)"E");

    public static String getDALFromControlCategoryAndSeverity(String controlCategory, String severity) {
        String toReturn = "Unspecified";
        if (!"Unspecified".equals(controlCategory) && !"Unspecified".equals(severity)) {
            toReturn = criticalityMap[SafetyCriticalityLookup.getControlLevel(controlCategory)][SafetyCriticalityLookup.getSeverityLevel(severity)];
        }
        return toReturn;
    }

    public static String getDALLevelFromInt(Integer level) {
        if (level < 0 || level > 4) {
            throw new OseeArgumentException("Invalid DAL level: %d", new Object[]{level});
        }
        return criticalityMap[1][level];
    }

    public static String getDALLevelFromSeverityCategory(String sevCat) {
        String toReturn = "Unspecified";
        if (!"Unspecified".equals(sevCat)) {
            if (!safetyCriticalityMap.keySet().contains(sevCat)) {
                throw new OseeArgumentException("Invalid severity category: %s", new Object[]{sevCat});
            }
            toReturn = safetyCriticalityMap.get(sevCat);
        }
        return toReturn;
    }

    public static Integer getSeverityLevel(String sevCat) {
        if (!severityCategoryMap.keySet().contains(sevCat)) {
            throw new OseeArgumentException("Invalid severity category: %s", new Object[]{sevCat});
        }
        return severityCategoryMap.get(sevCat);
    }

    public static Integer getControlLevel(String controlCategory) {
        if (!controlCategoryMap.keySet().contains(controlCategory)) {
            throw new OseeArgumentException("Invalid control category: %s", new Object[]{controlCategory});
        }
        return controlCategoryMap.get(controlCategory);
    }

    public static Integer getDALLevel(String DALCategory) {
        if (!DALCategoryMap.keySet().contains(DALCategory)) {
            throw new OseeArgumentException("Invalid DAL category: %s", new Object[]{DALCategory});
        }
        return DALCategoryMap.get(DALCategory);
    }
}

