/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.report.internal;

import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.osee.app.OseeAppletPage;
import org.eclipse.osee.define.report.internal.PublishLowHighReqStreamingOutput;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.jdk.core.type.IResourceRegistry;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsTypes;
import org.eclipse.osee.orcs.data.ArtifactTypes;
import org.eclipse.osee.template.engine.AppendableRule;
import org.eclipse.osee.template.engine.ArtifactTypeOptionsRule;

@Path(value="/traceability/highlowtrace")
public final class PublishLowHighReqTraceabilityResource {
    private final OrcsApi orcsApi;
    private final IResourceRegistry resourceRegistry;
    private final Log logger;

    public PublishLowHighReqTraceabilityResource(Log logger, IResourceRegistry resourceRegistry, OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
        this.resourceRegistry = resourceRegistry;
        this.logger = logger;
    }

    @GET
    @Produces(value={"application/xml"})
    public Response getLowHighReqReport(@QueryParam(value="branch") BranchId branch, @QueryParam(value="selected_types") String selectedTypes) {
        Conditions.checkNotNull((Object)branch, (String)"branch query param");
        Conditions.checkNotNull((Object)selectedTypes, (String)"selected_types query param");
        PublishLowHighReqStreamingOutput streamingOutput = new PublishLowHighReqStreamingOutput(this.logger, this.orcsApi, branch, selectedTypes);
        String fileName = "Requirement_Trace_Report.xml";
        Response.ResponseBuilder builder = Response.ok((Object)streamingOutput);
        builder.header("Content-Disposition", (Object)("attachment; filename=" + fileName));
        return builder.build();
    }

    @Path(value="ui")
    @GET
    @Produces(value={"text/html"})
    public String getApplet() {
        OseeAppletPage pageUtil = new OseeAppletPage(this.orcsApi.getQueryFactory().branchQuery());
        ArtifactTypeOptionsRule selectRule = new ArtifactTypeOptionsRule("artifactTypeSelect", this.getTypes(), new HashSet());
        return pageUtil.realizeApplet(this.resourceRegistry, "publishLowHighReport.html", this.getClass(), new AppendableRule[]{selectRule});
    }

    private Set<String> getTypes() {
        OrcsTypes orcsTypes = this.orcsApi.getOrcsTypes();
        ArtifactTypes artifactTypes = orcsTypes.getArtifactTypes();
        HashSet<String> toReturn = new HashSet<String>();
        for (IArtifactType type : artifactTypes.getAll()) {
            toReturn.add(type.getName());
        }
        return toReturn;
    }
}

