/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.report.internal;

import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.eclipse.osee.app.OseeAppletPage;
import org.eclipse.osee.define.report.internal.DataRightsStreamingOutput;
import org.eclipse.osee.define.report.internal.TraceAccumulator;
import org.eclipse.osee.define.report.internal.TraceMatch;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.data.TokenFactory;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.jdk.core.type.IResourceRegistry;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.BranchReadable;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.eclipse.osee.orcs.transaction.TransactionFactory;

@Path(value="/traceability/datarights")
public final class DataRightsSwReqAndCodeResource {
    private final OrcsApi orcsApi;
    private final IResourceRegistry resourceRegistry;
    private final Map<String, Object> properties;
    private final Log logger;
    private final QueryFactory queryFactory;
    private static final IArtifactType WCAFE = TokenFactory.createArtifactType((long)204509162766367L, (String)"WCAFE");

    public DataRightsSwReqAndCodeResource(Log logger, Map<String, Object> properties, IResourceRegistry resourceRegistry, OrcsApi orcsApi) {
        this.properties = properties;
        this.resourceRegistry = resourceRegistry;
        this.orcsApi = orcsApi;
        this.queryFactory = orcsApi.getQueryFactory();
        this.logger = logger;
    }

    @GET
    @Produces(value={"application/xml"})
    public Response getDataRightspReport(@QueryParam(value="branch") BranchId branch, @QueryParam(value="code_root") String codeRoot) {
        TraceMatch match = new TraceMatch("\\^SRS\\s*([^;]+);?", null);
        TraceAccumulator traceAccumulator = new TraceAccumulator(".*\\.(java|ada|ads|adb|c|h)", match);
        DataRightsStreamingOutput streamingOutput = new DataRightsStreamingOutput(this.orcsApi, branch, codeRoot, traceAccumulator, this.logger);
        Response.ResponseBuilder builder = Response.ok((Object)streamingOutput);
        String fileName = "Req_Code_Data_Rights_Trace_Report.xml";
        builder.header("Content-Disposition", (Object)("attachment; filename=" + fileName));
        return builder.build();
    }

    @Path(value="ui")
    @GET
    @Produces(value={"text/html"})
    public String getApplet() {
        OseeAppletPage pageUtil = new OseeAppletPage(this.queryFactory.branchQuery());
        return pageUtil.realizeApplet(this.resourceRegistry, "dataRightsReport.html", this.getClass());
    }

    @Path(value="validate")
    @GET
    @Produces(value={"text/html"})
    public String check(@QueryParam(value="branchId") BranchId branchId) {
        ResultSet results = ((QueryBuilder)this.queryFactory.fromBranch(branchId).andIsOfType(new ArtifactTypeId[]{CoreArtifactTypes.AbstractSoftwareRequirement})).getResults();
        StringBuilder strb = new StringBuilder(2000);
        int count = 0;
        for (ArtifactReadable art : results) {
            if (art.isOfType(new ArtifactTypeId[]{WCAFE})) continue;
            String classification = (String)art.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.DataRightsClassification, (Object)"");
            String subsystem = (String)art.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Subsystem, (Object)"");
            String sme = (String)art.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.SubjectMatterExpert, (Object)"");
            if (!subsystem.equals("Controls and Displays") && !subsystem.equals("Mission System Management") && !subsystem.equals("Data Management") && !subsystem.equals("Unmanned Systems Management")) continue;
            if (classification.isEmpty()) {
                this.appendDetails("missing classification", strb, art, subsystem, classification);
            }
            if (sme.equals("")) {
                this.appendDetails("missing sme", strb, art, subsystem, classification);
            }
            ++count;
        }
        strb.append("done" + count);
        return strb.toString();
    }

    @Path(value="software")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    public Response copySWReqDataRights(@Context HttpHeaders httpHeaders, @FormParam(value="sourceBranch") BranchId sourceBranch, @FormParam(value="destinationBranch") BranchId destinationBranch) throws Exception {
        return this.copyDataRights(sourceBranch, destinationBranch, CoreArtifactTypes.AbstractSoftwareRequirement);
    }

    @Path(value="ssd")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    public Response copySSDDataRights(@Context HttpHeaders httpHeaders, @FormParam(value="sourceBranch") BranchId sourceBranch, @FormParam(value="destinationBranch") BranchId destinationBranch) throws Exception {
        return this.copyDataRights(sourceBranch, destinationBranch, CoreArtifactTypes.SubsystemDesign);
    }

    private Response copyDataRights(BranchId sourceBranch, BranchId destinationBranch, IArtifactType artifactType) throws Exception {
        ResultSet results = ((QueryBuilder)this.queryFactory.fromBranch(destinationBranch).andIsOfType(new ArtifactTypeId[]{artifactType})).getResults();
        String branchName = ((BranchReadable)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(sourceBranch)).getResults().getExactlyOne()).getName();
        String txMsg = "Copy data rights for " + artifactType + " from " + branchName;
        TransactionBuilder txBuilder = this.createTxBuilder(txMsg, destinationBranch);
        StringBuilder strb = new StringBuilder(2000);
        int count = 0;
        for (ArtifactReadable dest : results) {
            if (dest.isOfType(new ArtifactTypeId[]{WCAFE})) continue;
            ArtifactReadable source = (ArtifactReadable)((QueryBuilder)this.queryFactory.fromBranch(sourceBranch).andId((ArtifactId)dest)).getResults().getAtMostOneOrNull();
            if (source == null) {
                String classification = (String)dest.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.DataRightsClassification, (Object)"");
                String subsystem = (String)dest.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Subsystem, (Object)"");
                this.appendDetails("missing source", strb, dest, subsystem, classification);
                continue;
            }
            this.setBestValue(txBuilder, source, dest, (AttributeTypeId)CoreAttributeTypes.DataRightsClassification);
            this.setBestValue(txBuilder, source, dest, (AttributeTypeId)CoreAttributeTypes.SubjectMatterExpert);
            this.setBestValue(txBuilder, source, dest, (AttributeTypeId)CoreAttributeTypes.DataRightsBasis);
            ++count;
        }
        txBuilder.commit();
        strb.append("done: " + count);
        Response.ResponseBuilder builder = Response.ok((Object)strb.toString());
        builder.header("Content-Type", (Object)"text/plain");
        return builder.build();
    }

    private void appendDetails(String msg, StringBuilder strb, ArtifactReadable art, String subsystem, String classification) {
        strb.append(String.valueOf(msg) + "|" + subsystem + "|" + classification + " |" + art.getArtifactType() + "| " + art.getName() + "| " + art.getId() + "| " + art.getLastModifiedTransaction() + "<br />");
    }

    private TransactionBuilder createTxBuilder(String comment, BranchId branchId) {
        TransactionFactory txFactory = this.orcsApi.getTransactionFactory();
        ArtifactReadable userArtifact = (ArtifactReadable)((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andUuid(50L)).getResults().getExactlyOne();
        return txFactory.createTransaction(branchId, (ArtifactId)userArtifact, comment);
    }

    private void setBestValue(TransactionBuilder txBuilder, ArtifactReadable source, ArtifactReadable dest, AttributeTypeId attributeType) throws Exception {
        String value = (String)dest.getSoleAttributeValue(attributeType, (Object)"");
        String sourceValue = (String)source.getSoleAttributeValue(attributeType, (Object)"Unspecified");
        if (sourceValue.equals("Unspecified")) {
            if (value.isEmpty() && attributeType.equals(CoreAttributeTypes.DataRightsClassification)) {
                txBuilder.setSoleAttributeValue((ArtifactId)dest, attributeType, (Object)"Unspecified");
            }
        } else if (value.isEmpty()) {
            txBuilder.setSoleAttributeValue((ArtifactId)dest, attributeType, (Object)sourceValue);
        } else if (!value.equals(sourceValue)) {
            this.logger.warn("%s", new Object[]{String.valueOf(dest.getName()) + " conflict with " + attributeType});
        }
    }
}

