/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.report.internal;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.eclipse.osee.define.report.ParagraphNumberComparator;
import org.eclipse.osee.define.report.internal.TraceAccumulator;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.data.IOseeBranch;
import org.eclipse.osee.framework.core.data.TokenFactory;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.CaseInsensitiveString;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelColumn;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.search.QueryFactory;

public final class DataRightsStreamingOutput
implements StreamingOutput {
    private final QueryFactory queryFactory;
    private final IOseeBranch branch;
    private final String codeRoot;
    private final TraceAccumulator traceAccumulator;
    private final Map<CaseInsensitiveString, ArtifactReadable> nameToReqMap = new LinkedHashMap<CaseInsensitiveString, ArtifactReadable>();
    private final List<ArtifactReadable> noTraceReqs = new ArrayList<ArtifactReadable>();
    private ExcelXmlWriter writer;
    private final Log logger;
    private static final IArtifactType WCAFE = TokenFactory.createArtifactType((long)204509162766367L, (String)"WCAFE");

    public DataRightsStreamingOutput(OrcsApi orcsApi, BranchId branch, String codeRoot, TraceAccumulator traceAccumulator, Log logger) {
        this.queryFactory = orcsApi.getQueryFactory();
        BranchQuery branchQuery = orcsApi.getQueryFactory().branchQuery();
        this.branch = (IOseeBranch)((BranchQuery)branchQuery.andId(branch)).getResults().getExactlyOne();
        this.codeRoot = codeRoot.trim();
        this.traceAccumulator = traceAccumulator;
        this.logger = logger;
    }

    public void write(OutputStream output) {
        try {
            Date startTime = new Date();
            this.traceAccumulator.extractTraces(new File(this.codeRoot));
            this.writer = new ExcelXmlWriter((Writer)new OutputStreamWriter(output, "UTF-8"));
            this.writeReqCodeRightsSheet();
            this.writeNoTraceFilesSheet();
            this.writeNoTraceReqsSheet();
            this.writeInvalidTraceSheet();
            this.writeSummary(startTime);
            this.writer.endWorkbook();
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    private void writeInvalidTraceSheet() throws IOException {
        this.writer.startSheet("Invalid Marks", new ExcelColumn[]{ExcelColumn.newCol((String)"File", (double)400.0), ExcelColumn.newCol((String)"Mark Text", (double)400.0)});
        for (String file : this.traceAccumulator.getFilesWithMalformedMarks()) {
            for (String mark : this.traceAccumulator.getMalformedMarks(file)) {
                this.writer.writeRow(new Object[]{file, mark});
            }
        }
        this.writer.endSheet();
    }

    private void writeReqCodeRightsSheet() throws IOException {
        this.writer.startSheet("Req & Code Rights", new ExcelColumn[]{ExcelColumn.newCol((String)"Req Name", (double)400.0), ExcelColumn.newCol((String)"Requirement Type", (double)120.0), ExcelColumn.newCol((String)"Req Data Rights", (double)100.0), ExcelColumn.newCol((String)"Code Unit", (double)500.0), ExcelColumn.newCol((String)"Code Data Rights", (double)100.0), ExcelColumn.newCol((String)"Consistency Check", (double)100.0)});
        QueryBuilder query = (QueryBuilder)this.queryFactory.fromBranch((BranchId)this.branch).andIsOfType(new ArtifactTypeId[]{CoreArtifactTypes.AbstractSoftwareRequirement});
        for (ArtifactReadable req : query.getResults().sort((Comparator)new ParagraphNumberComparator(this.logger))) {
            if (req.isOfType(new ArtifactTypeId[]{WCAFE})) continue;
            String reqName = req.getName();
            this.nameToReqMap.put(new CaseInsensitiveString(reqName), req);
            ArrayList<String> codeUnits = new ArrayList<String>(this.traceAccumulator.getFiles(reqName));
            if (codeUnits.isEmpty()) {
                this.writeReq(req, reqName);
                this.writer.endRow();
                continue;
            }
            Collections.sort(codeUnits);
            for (String codeunit : codeUnits) {
                this.writeReq(req, reqName);
                this.writeCode(codeunit);
            }
        }
        this.writer.endSheet();
    }

    private void writeReq(ArtifactReadable req, String reqName) throws IOException {
        this.writer.writeCell((Object)reqName);
        this.writer.writeCell((Object)req.getArtifactType());
        this.writer.writeCell(req.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.DataRightsClassification, (Object)"missing"));
    }

    private void writeCode(String path) throws IOException {
        this.writer.writeCell((Object)path);
        this.writer.endRow();
    }

    private void writeNoTraceFilesSheet() throws IOException {
        this.writer.startSheet("No Trace Files", new ExcelColumn[]{ExcelColumn.newCol((double)700.0)});
        for (String path : this.traceAccumulator.getNoTraceFiles()) {
            this.writer.writeRow(new Object[]{path});
        }
        this.writer.endSheet();
    }

    private void writeNoTraceReqsSheet() throws IOException {
        this.writer.startSheet("No Trace Reqs", new ExcelColumn[]{ExcelColumn.newCol((String)"Paragraph #", (double)85.0), ExcelColumn.newCol((String)"Req Name", (double)400.0), ExcelColumn.newCol((String)"Requirement Type", (double)110.0)});
        for (ArtifactReadable req : this.noTraceReqs) {
            this.writeReq(req, req.getName());
            this.writer.endRow();
        }
        this.writer.endSheet();
        this.noTraceReqs.clear();
    }

    private void writeSummary(Date start) throws IOException {
        this.writer.startSheet("Summary", new ExcelColumn[]{ExcelColumn.newCol((String)"Description", (double)400.0), ExcelColumn.newCol((String)"Value", (double)400.0)});
        this.writer.writeRow(new Object[]{"Code Root", this.codeRoot});
        this.writer.writeRow(new Object[]{"Branch Name", this.branch.getName()});
        Date now = Calendar.getInstance().getTime();
        this.writer.writeRow(new Object[]{"Report Date", now.toString()});
        this.writer.writeRow(new Object[]{"Elapsed Time", Lib.getElapseString((long)start.getTime())});
        this.writer.endSheet();
    }
}

