/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.report;

import java.util.Collection;
import java.util.Set;
import org.eclipse.osee.define.report.api.WordTemplateContentData;
import org.eclipse.osee.define.report.api.WordUpdateChange;
import org.eclipse.osee.define.report.api.WordUpdateData;
import org.eclipse.osee.define.report.api.WordUpdateEndpoint;
import org.eclipse.osee.define.report.internal.wordupdate.WordTemplateContentRendererHandler;
import org.eclipse.osee.define.report.internal.wordupdate.WordUpdateArtifact;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.osgi.service.event.EventAdmin;

public final class WordUpdateEndpointImpl
implements WordUpdateEndpoint {
    private final OrcsApi orcsApi;
    private final Log logger;
    private final EventAdmin eventAdmin;

    public WordUpdateEndpointImpl(Log logger, OrcsApi orcsApi, EventAdmin eventAdmin) {
        this.orcsApi = orcsApi;
        this.logger = logger;
        this.eventAdmin = eventAdmin;
    }

    public WordUpdateChange updateWordArtifacts(WordUpdateData data) {
        WordUpdateArtifact updateArt = new WordUpdateArtifact(this.logger, this.orcsApi, this.eventAdmin);
        this.validate(data);
        return updateArt.updateArtifacts(data);
    }

    protected void validate(WordUpdateData data) {
        Conditions.checkNotNull((Object)data, (String)"WordUpdateData");
        Conditions.checkNotNullOrEmpty((String)data.getComment(), (String)"WordUpdateData comment");
        Conditions.checkNotNullOrEmpty((Collection)data.getArtifacts(), (String)"WordUpdateData artifacts");
        Conditions.checkExpressionFailOnTrue((data.getUserArtId() <= 0L ? 1 : 0) != 0, (String)"WordUpdateData invalid user id %d", (Object[])new Object[]{data.getUserArtId()});
        Conditions.checkExpressionFailOnTrue((boolean)data.getBranch().isInvalid(), (String)"WordUpdateData invalid branch %s", (Object[])new Object[]{data.getBranch()});
        Conditions.checkNotNull((Object)data.getWordData(), (String)"WordUpdateData content");
    }

    public Pair<String, Set<String>> renderWordTemplateContent(WordTemplateContentData data) throws OseeCoreException {
        WordTemplateContentRendererHandler wordRendererHandler = new WordTemplateContentRendererHandler(this.orcsApi, this.logger);
        return wordRendererHandler.renderWordML(data);
    }
}

