/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.report;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.define.report.AlternateTypeOutput;
import org.eclipse.osee.define.report.internal.TraceAccumulator;
import org.eclipse.osee.define.report.internal.TraceInformationAccumulator;
import org.eclipse.osee.define.report.internal.TraceMatch;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.CaseInsensitiveString;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ISheetWriter;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.search.QueryFactory;

public class TraceReportGenerator {
    private TraceInformationAccumulator accumulator;
    private QueryFactory queryFactory;
    private final AlternateTypeOutput altRequirementType;
    private final TraceMatch match;
    private final TraceAccumulator traces;
    private final TraceMatch testMatch;
    private final TraceAccumulator testTraces;
    public static int SOFTWARE_SHEETREQ_INDEX = 3;
    public static int SOFTWARE_REQUIREMENT_INDEX = 4;
    public static int SOFTWARE_COMPONENT_INDEX = 7;
    public static int SOFTWARE_PROCEDURE_INDEX = 9;
    public static int SOFTWARE_SCRIPT_INDEX = 11;
    public static int SOFTWARE_CODEUNIT_INDEX = 13;
    public static int SOFTWARE_TRACEUNIT_INDEX = 14;
    private final String[] columnHeadings = new String[]{"Doors ID", "Paragraph #", "System Requirement Name", "Qualification Information", CoreArtifactTypes.SoftwareRequirement.getName(), "ArtifactId", "Equivalent SW Qual Level", "Traced Component Name", "Trace Component ArtifactId", "Traced Test Procedure Name", "Traced Test Procedure ArtifactId", "Traced Test Script Name", "Traced Test Script ArtifactId", "Traced Code Unit Name", "Traced Test Unit Name"};
    private final String[] columnHeadingsComponent = new String[]{"Doors ID", "Paragraph #", "System Requirement Name", CoreArtifactTypes.Component.getName(), "ArtifactId"};
    private final String[] columnHeadingsTest = new String[]{"Doors ID", "Paragraph #", "System Requirement Name", CoreArtifactTypes.TestPlanElement.getName(), "ArtifactId"};

    private void init(OrcsApi orcsApi, ISheetWriter writer) {
        this.accumulator = new TraceInformationAccumulator(this, writer);
        this.queryFactory = orcsApi.getQueryFactory();
    }

    public TraceReportGenerator(String reqFileMatch, String reqTraceMatch, String testFileMatch, String testTraceMatch, AlternateTypeOutput altReqType) {
        this.altRequirementType = altReqType;
        this.match = new TraceMatch(reqTraceMatch, null);
        this.traces = new TraceAccumulator(reqFileMatch, this.match);
        this.testMatch = new TraceMatch(testTraceMatch, null);
        this.testTraces = new TraceAccumulator(testFileMatch, this.testMatch);
    }

    public void generate(OrcsApi providedOrcs, BranchId branchId, String codeRoot, String traceRoot, Writer providedWriter) throws IOException {
        ExcelXmlWriter writer = new ExcelXmlWriter(providedWriter);
        if (Strings.isValid((String)codeRoot)) {
            File root = new File(codeRoot);
            this.traces.extractTraces(root);
            this.writeTracesSheet((ISheetWriter)writer, "code traces", this.traces);
        }
        if (Strings.isValid((String)traceRoot)) {
            File troot = new File(traceRoot);
            this.testTraces.extractTraces(troot);
            this.writeTracesSheet((ISheetWriter)writer, "test traces", this.testTraces);
        }
        this.init(providedOrcs, (ISheetWriter)writer);
        ArtifactReadable requirementsFolder = (ArtifactReadable)((QueryBuilder)((QueryBuilder)this.queryFactory.fromBranch(branchId).andIsOfType(new ArtifactTypeId[]{CoreArtifactTypes.Folder})).andNameEquals("System Requirements")).getResults().getExactlyOne();
        List systemRequirements = requirementsFolder.getDescendants();
        this.processReqts(systemRequirements, (ISheetWriter)writer);
        this.processComponents(systemRequirements, (ISheetWriter)writer);
        this.processTests(systemRequirements, (ISheetWriter)writer);
        this.processTestPlans(systemRequirements, (ISheetWriter)writer);
        writer.endWorkbook();
    }

    public AlternateTypeOutput getAlternateRequirementType() {
        return this.altRequirementType;
    }

    private void writeTracesSheet(ISheetWriter writer, String name, TraceAccumulator accum) throws IOException {
        writer.startSheet(name, 2);
        writer.writeCell((Object)"Trace requirement name");
        writer.writeCell((Object)"Traced file");
        writer.endRow();
        for (CaseInsensitiveString key : accum.getTraceMarks()) {
            for (String result : accum.getFiles(key.toString())) {
                writer.writeCell((Object)key);
                writer.writeCell((Object)result);
                writer.endRow();
            }
        }
        writer.endSheet();
    }

    private void processReqts(List<ArtifactReadable> systemRequirements, ISheetWriter writer) throws IOException {
        writer.startSheet("Software Reqts", this.columnHeadings.length);
        writer.writeRow((Object[])this.columnHeadings);
        for (ArtifactReadable systemReqt : systemRequirements) {
            if (!systemReqt.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.SystemRequirementHTML})) continue;
            this.outputCommonCells(systemReqt, writer);
            writer.writeCell((Object)this.accumulator.getAttributesToStringList(systemReqt, (AttributeTypeId)CoreAttributeTypes.QualificationMethod));
            this.accumulator.outputSubsystemsRequirementsMap(systemReqt, writer);
        }
        writer.endSheet();
    }

    private void processComponents(List<ArtifactReadable> systemRequirements, ISheetWriter writer) throws IOException {
        writer.startSheet("Components", this.columnHeadingsComponent.length);
        writer.writeRow((Object[])this.columnHeadingsComponent);
        for (ArtifactReadable systemReqt : systemRequirements) {
            if (!systemReqt.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.SystemRequirementHTML})) continue;
            this.outputCommonCells(systemReqt, writer);
            this.accumulator.outputSubsystemsComponentsMap(systemReqt, writer);
        }
        writer.endSheet();
    }

    private void processTests(List<ArtifactReadable> systemRequirements, ISheetWriter writer) throws IOException {
        writer.startSheet("Tests", this.columnHeadingsTest.length);
        writer.writeRow((Object[])this.columnHeadingsTest);
        for (ArtifactReadable systemReqt : systemRequirements) {
            if (!systemReqt.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.SystemRequirementHTML})) continue;
            this.outputCommonCells(systemReqt, writer);
            this.accumulator.outputSubsystemsTestsMap(systemReqt, writer);
        }
        writer.endSheet();
    }

    private void processTestPlans(List<ArtifactReadable> systemRequirements, ISheetWriter writer) throws IOException {
        writer.startSheet("Test Plans", this.columnHeadingsTest.length);
        writer.writeRow((Object[])this.columnHeadingsTest);
        for (ArtifactReadable systemReqt : systemRequirements) {
            if (!systemReqt.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.SystemRequirementHTML})) continue;
            this.outputCommonCells(systemReqt, writer);
            this.accumulator.outputSubsystemsTestPlansMap(systemReqt, writer);
        }
        writer.endSheet();
    }

    private void outputCommonCells(ArtifactReadable systemRequirement, ISheetWriter writer) throws IOException {
        writer.writeCell((Object)systemRequirement.getIdString());
        writer.writeCell((Object)systemRequirement.getSoleAttributeAsString((AttributeTypeId)CoreAttributeTypes.ParagraphNumber));
        writer.writeCell((Object)systemRequirement.getName());
    }

    public Collection<String> getRequirementToCodeUnitsValues(ArtifactReadable softwareRequirement) {
        return this.traces.getFiles(this.accumulator.handleEquivalentName(softwareRequirement));
    }

    public Collection<String> getRequirementToTraceUnitsValues(ArtifactReadable softwareRequirement) {
        return this.testTraces.getFiles(this.accumulator.handleEquivalentName(softwareRequirement));
    }
}

