/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.report;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import org.eclipse.osee.define.report.internal.SafetyCriticalityLookup;
import org.eclipse.osee.define.report.internal.SafetyInformationAccumulator;
import org.eclipse.osee.define.report.internal.TraceAccumulator;
import org.eclipse.osee.define.report.internal.TraceMatch;
import org.eclipse.osee.define.report.internal.util.ComponentUtil;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ISheetWriter;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.search.QueryFactory;

public class SafetyReportGenerator {
    private SafetyInformationAccumulator accumulator;
    private QueryFactory queryFactory;
    private ComponentUtil componentUtil;
    private final TraceMatch match = new TraceMatch("\\^SRS\\s*([^;]+);?", "\\[?(\\{[^\\}]+\\})(.*)");
    private final TraceAccumulator traces = new TraceAccumulator(".*\\.(java|ada|ads|adb|c|h)", this.match);
    private final Log logger;
    public static int SYSTEM_REQUIREMENT_INDEX = 8;
    public static int SUBSYSTEM_FUNCTION_INDEX = 9;
    public static int SUBSYSTEM_INDEX = 13;
    public static int SOFTWARE_REQUIREMENT_INDEX = 19;
    public static int CODE_UNIT_INDEX = 28;
    private final String[] columnHeadings = new String[]{"System Function", "Severity Category", "SFHA Hazard(s)", "Hazard Level Test", "Software Safety Impact", "System FDAL", "System FDAL Rationale", "Paragraph #", "System Requirement Name", "Subsystem Function", "Subsystem Severity Category", "Subsystem FDAL", "Subsystem FDAL Rationale", CoreAttributeTypes.Subsystem.getName(), "Paragraph #", "Subsystem Requirement Name", "Subsystem Requirement IDAL", "Subsystem Requirement IDAL Rationale", "Subsystem Requirement Level Check", CoreArtifactTypes.SoftwareRequirement.getName(), "IDAL", "IDAL Rationale", "Software Control Category", "Software Control Category Rationale", "Boeing Equivalent SW Qual Level", "Functional Category", "SW Partition", "SW CSU", "SW Code Unit"};

    public SafetyReportGenerator(Log logger) {
        this.logger = logger;
    }

    private void init(OrcsApi orcsApi, BranchId branchId, ISheetWriter writer) {
        this.accumulator = new SafetyInformationAccumulator(this, writer);
        this.queryFactory = orcsApi.getQueryFactory();
        this.componentUtil = new ComponentUtil(branchId, orcsApi);
    }

    public void runOperation(OrcsApi providedOrcs, BranchId branchId, String codeRoot, Writer providedWriter) throws IOException {
        ExcelXmlWriter writer = new ExcelXmlWriter(providedWriter);
        this.init(providedOrcs, branchId, (ISheetWriter)writer);
        boolean doTracability = false;
        if (codeRoot != null && !codeRoot.isEmpty()) {
            doTracability = true;
        }
        if (doTracability) {
            File root = new File(codeRoot);
            this.traces.extractTraces(root);
        }
        ArtifactReadable functionsFolder = (ArtifactReadable)((QueryBuilder)((QueryBuilder)this.queryFactory.fromBranch(branchId).andIsOfType(new ArtifactTypeId[]{CoreArtifactTypes.Folder})).andNameEquals("System Functions")).getResults().getExactlyOne();
        this.processSystemFunctions(functionsFolder, (ISheetWriter)writer);
        writer.endWorkbook();
    }

    private void processSystemFunctions(ArtifactReadable functionsFolder, ISheetWriter writer) throws IOException {
        writer.startSheet("report", this.columnHeadings.length);
        writer.writeRow((Object[])this.columnHeadings);
        for (ArtifactReadable systemFunction : functionsFolder.getDescendants()) {
            String sevCat;
            if (!systemFunction.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.SystemFunction})) continue;
            writer.writeCell((Object)systemFunction.getName());
            this.accumulator.reset(systemFunction);
            this.accumulator.buildSubsystemsRequirementsMap(systemFunction);
            if (systemFunction.getAttributes((AttributeTypeId)CoreAttributeTypes.SeverityCategory).size() != 1) {
                this.logger.debug("found too many attributes on %s", new Object[]{systemFunction.toString()});
                sevCat = ((AttributeReadable)systemFunction.getAttributes((AttributeTypeId)CoreAttributeTypes.SeverityCategory).iterator().next()).getDisplayableString();
            } else {
                sevCat = systemFunction.getSoleAttributeAsString((AttributeTypeId)CoreAttributeTypes.SeverityCategory);
            }
            writer.writeCell((Object)sevCat);
            this.writeSFHAInfo(systemFunction, sevCat, writer);
            writer.writeCell((Object)systemFunction.getSoleAttributeAsString((AttributeTypeId)CoreAttributeTypes.SoftwareSafetyImpact, ""));
            writer.writeCell((Object)systemFunction.getSoleAttributeAsString((AttributeTypeId)CoreAttributeTypes.FunctionalDAL, ""));
            writer.writeCell((Object)systemFunction.getSoleAttributeAsString((AttributeTypeId)CoreAttributeTypes.FunctionalDALRationale, ""));
            for (ArtifactReadable systemRequirement : systemFunction.getRelated(CoreRelationTypes.Design__Requirement)) {
                writer.writeCell(systemRequirement.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ParagraphNumber, (Object)""));
                writer.writeCell((Object)systemRequirement.getName(), SYSTEM_REQUIREMENT_INDEX);
                this.accumulator.output();
            }
            writer.endRow();
        }
        writer.endSheet();
    }

    private void writeSFHAInfo(ArtifactReadable systemFunction, String sevCat, ISheetWriter writer) throws IOException {
        ResultSet results = systemFunction.getRelated(CoreRelationTypes.Safety__Safety_Assessment);
        if (results.isEmpty()) {
            writer.writeCell((Object)"No SFHA Hazards found");
            writer.writeCell((Object)"N/A");
        } else {
            writer.writeCell((Object)this.getSFHAHazards((ResultSet<ArtifactReadable>)results));
            writer.writeCell((Object)this.compareHazardLevel((ResultSet<ArtifactReadable>)results, sevCat));
        }
    }

    private String getSFHAHazards(ResultSet<ArtifactReadable> results) {
        StringBuilder sb = new StringBuilder();
        for (ArtifactReadable assessment : results) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(assessment.getSoleAttributeAsString((AttributeTypeId)CoreAttributeTypes.ParagraphNumber, ""));
            sb.append(" ");
            sb.append(assessment.getSoleAttributeAsString((AttributeTypeId)CoreAttributeTypes.Name, ""));
            sb.append(" ");
            sb.append((String)assessment.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Sfha, (Object)""));
        }
        return sb.toString();
    }

    private String compareHazardLevel(ResultSet<ArtifactReadable> results, String sevCat) {
        String toReturn = "System Function Severity Category invalid";
        try {
            Integer sevCatLevel = SafetyCriticalityLookup.getSeverityLevel(sevCat);
            toReturn = "good: " + sevCat;
            for (ArtifactReadable assessment : results) {
                String sfha = assessment.getSoleAttributeAsString((AttributeTypeId)CoreAttributeTypes.Sfha);
                if (!Strings.isValid((String)sfha)) continue;
                String[] sfhaSevCat = sfha.split(" ");
                Integer sfhaSevCatLevel = SafetyCriticalityLookup.getSeverityLevel(sfhaSevCat[2]);
                if (sevCatLevel <= sfhaSevCatLevel) continue;
                toReturn = "bad: " + sevCat + " > " + sfhaSevCat[2];
            }
        }
        catch (Exception ex) {
            toReturn = ex.getMessage();
        }
        return toReturn;
    }

    public Collection<String> getRequirementToCodeUnitsValues(ArtifactReadable softwareRequirement) {
        return this.traces.getFiles(softwareRequirement.getName());
    }

    public ComponentUtil getComponentUtil() {
        return this.componentUtil;
    }
}

