/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.report;

import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public final class ParagraphNumberComparator
implements Comparator<ArtifactReadable> {
    private final Log logger;

    public ParagraphNumberComparator(Log logger) {
        this.logger = logger;
    }

    @Override
    public int compare(ArtifactReadable art1, ArtifactReadable art2) {
        try {
            int size;
            int toReturn = 0;
            String paragraph1 = (String)art1.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ParagraphNumber, (Object)"");
            String paragraph2 = (String)art2.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ParagraphNumber, (Object)"");
            Integer[] set1 = this.getParagraphIndices(paragraph1);
            Integer[] set2 = this.getParagraphIndices(paragraph2);
            int length1 = set1.length;
            int length2 = set2.length;
            int n = size = length1 < length2 ? length1 : length2;
            if (size == 0 && length1 != length2) {
                toReturn = length1 < length2 ? -1 : 1;
            } else {
                int index = 0;
                while (index < size) {
                    toReturn = set1[index].compareTo(set2[index]);
                    if (toReturn != 0) break;
                    ++index;
                }
            }
            return toReturn;
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex, "Error in paragraph number comparator", new Object[0]);
            return 1;
        }
    }

    private Integer[] getParagraphIndices(String paragraph) {
        ArrayList<Integer> paragraphs = new ArrayList<Integer>();
        if (Strings.isValid((String)paragraph)) {
            String[] values = paragraph.split("\\.");
            int index = 0;
            while (index < values.length) {
                paragraphs.add(new Integer(values[index].replace("-", "")));
                ++index;
            }
        }
        return paragraphs.toArray(new Integer[paragraphs.size()]);
    }
}

