/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.disposition.model.DispoSetStatus;
import org.eclipse.osee.disposition.model.DispoSummarySeverity;
import org.eclipse.osee.disposition.model.OperationSummaryEntry;

public class OperationReport {
    private DispoSetStatus status = DispoSetStatus.NO_CHANGE;
    private List<OperationSummaryEntry> entries = new ArrayList<OperationSummaryEntry>();

    public List<OperationSummaryEntry> getEntries() {
        return this.entries;
    }

    public void addEntry(String name, String message, DispoSummarySeverity serverity) {
        if (serverity == DispoSummarySeverity.ERROR) {
            this.status = DispoSetStatus.FAILED;
        } else if (serverity == DispoSummarySeverity.WARNING && this.status != DispoSetStatus.FAILED) {
            this.status = DispoSetStatus.WARNINGS;
        } else if (this.status == DispoSetStatus.NO_CHANGE && (serverity == DispoSummarySeverity.NEW || serverity == DispoSummarySeverity.UPDATE)) {
            this.status = DispoSetStatus.OK;
        }
        OperationSummaryEntry entry = new OperationSummaryEntry();
        entry.setName(name);
        entry.setMessage(message);
        entry.setSeverity(serverity);
        this.entries.add(entry);
    }

    public DispoSetStatus getStatus() {
        return this.status;
    }

    public void setStatus(DispoSetStatus status) {
        this.status = status;
    }

    public void setEntries(List<OperationSummaryEntry> entries) {
        this.entries = entries;
    }
}

