/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.impl.ResponseImpl;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.jaxrs.ErrorResponse;

public final class JaxRsExceptions {
    private JaxRsExceptions() {
    }

    public static boolean isErrorResponse(Response response) {
        String header = response.getHeaderString("osee-jaxrs-error-response");
        return Boolean.valueOf(header);
    }

    public static OseeCoreException asOseeException(Throwable th) {
        OseeCoreException toReturn = th instanceof ResponseProcessingException ? JaxRsExceptions.asOseeException((ResponseProcessingException)th) : (th instanceof WebApplicationException ? JaxRsExceptions.asOseeException((WebApplicationException)th) : (th instanceof OseeCoreException ? (OseeCoreException)th : new OseeCoreException(th.getCause(), th.getLocalizedMessage(), new Object[0])));
        return toReturn;
    }

    private static OseeCoreException asOseeException(ResponseProcessingException ex) {
        OseeCoreException toReturn;
        Response response = ex.getResponse();
        if (response.hasEntity()) {
            toReturn = JaxRsExceptions.asOseeException(response);
        } else {
            Throwable cause = ex.getCause();
            String message = JaxRsExceptions.buildExceptionMessage(response.getStatus(), cause, ex.getMessage());
            toReturn = new OseeCoreException(cause, message, new Object[0]);
        }
        return toReturn;
    }

    private static OseeCoreException asOseeException(WebApplicationException ex) {
        OseeCoreException toReturn;
        Response response = ex.getResponse();
        if (response.hasEntity()) {
            toReturn = JaxRsExceptions.asOseeException(response);
        } else {
            Throwable cause = ex.getCause();
            String message = JaxRsExceptions.buildExceptionMessage(response.getStatus(), cause, ex.getMessage());
            toReturn = new OseeCoreException(cause, message, new Object[0]);
        }
        return toReturn;
    }

    private static String buildExceptionMessage(int statusCode, Throwable cause, String exMessage) {
        String message;
        StringBuilder sb = new StringBuilder();
        sb.append("JAX-RS Client Exception caught - ").append(statusCode);
        String string = message = cause == null ? exMessage : cause.getMessage();
        if (message == null && cause != null) {
            message = "exception cause class: " + cause.getClass().getName();
        }
        if (message != null) {
            sb.append(", message: ").append(message);
        }
        return sb.toString();
    }

    public static OseeCoreException asOseeException(Response response) {
        String message = "";
        String httpStatus = "";
        if (response == null) {
            message = "Error mapping response exception - response was null";
        } else {
            block9: {
                if (response.hasEntity()) {
                    if (response.getStatus() == Response.Status.NOT_MODIFIED.getStatusCode()) {
                        return null;
                    }
                    Object entity = response.getEntity();
                    try {
                        if (JaxRsExceptions.isErrorResponse(response)) {
                            message = JaxRsExceptions.readEntity(response, ErrorResponse.class).toString();
                            break block9;
                        }
                        if (entity instanceof InputStream) {
                            MediaType mediaType = response.getMediaType();
                            message = JaxRsExceptions.readStream((InputStream)entity, mediaType);
                            break block9;
                        }
                        message = String.format("%s [%s]", JaxRsExceptions.getResponseString(response), entity);
                    }
                    catch (Throwable th) {
                        message = String.format("Error processing reponse error - %s [%s]", JaxRsExceptions.getResponseString(response), th.getLocalizedMessage());
                    }
                } else {
                    message = JaxRsExceptions.getResponseString(response);
                }
            }
            message = String.valueOf(message) + ".  HTTP Reason: " + response.getStatusInfo().getReasonPhrase();
            httpStatus = response.getStatusInfo().getReasonPhrase();
        }
        return new OseeCoreException(String.valueOf(message) + ". HTTP Status: " + httpStatus, new Object[0]);
    }

    private static String getResponseString(Response response) {
        StringBuilder builder = new StringBuilder();
        builder.append("status[");
        int statusCode = response.getStatus();
        builder.append(statusCode);
        builder.append("]");
        Response.Status status = Response.Status.fromStatusCode((int)statusCode);
        if (status != null) {
            builder.append(" reason[");
            builder.append(status.getReasonPhrase());
            builder.append("]");
        }
        return builder.toString();
    }

    private static <T> T readEntity(Response response, Class<T> clazz) {
        return (T)((ResponseImpl)response).doReadEntity(clazz, clazz, clazz.getAnnotations());
    }

    private static String readStream(InputStream inputStream, MediaType mediaType) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Lib.inputStreamToOutputStream((InputStream)inputStream, (OutputStream)outputStream);
        return outputStream.toString("UTF-8");
    }
}

