/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.client;

import java.net.URI;
import java.util.Map;
import org.eclipse.osee.jaxrs.client.JaxRsClientConfig;
import org.eclipse.osee.jaxrs.client.JaxRsClientConstants;
import org.eclipse.osee.jaxrs.client.JaxRsConfirmAccessHandler;
import org.eclipse.osee.jaxrs.client.JaxRsTokenStore;
import org.eclipse.osee.jaxrs.client.JaxRsWebTarget;
import org.eclipse.osee.jaxrs.client.internal.JaxRsClientRuntime;

public final class JaxRsClient {
    private final JaxRsClientConfig config;
    private final JaxRsClientFactory factory;
    private static Long accountId;
    private static Long clientId;
    private static Long serverId;

    public static JaxRsClientBuilder newBuilder() {
        JaxRsClientFactory factory = JaxRsClientRuntime.getClientFactoryInstance();
        return new JaxRsClientBuilder(factory);
    }

    public static JaxRsClientBuilder newBuilder(JaxRsClientConfig config) {
        return JaxRsClient.newBuilder().withConfig(config);
    }

    public static JaxRsClientBuilder newBuilder(Map<String, Object> properties) {
        return JaxRsClient.newBuilder().properties(properties);
    }

    public static JaxRsClient newClient() {
        return JaxRsClient.newBuilder().build();
    }

    public static JaxRsClient fromConfig(JaxRsClientConfig config) {
        return JaxRsClient.newBuilder(config).build();
    }

    public static JaxRsClient fromProperties(Map<String, Object> properties) {
        return JaxRsClient.newBuilder(properties).build();
    }

    protected JaxRsClient(JaxRsClientFactory factory, JaxRsClientConfig config) {
        this.config = config;
        this.factory = factory;
    }

    public JaxRsWebTarget target() {
        return this.target((String)null);
    }

    public JaxRsWebTarget target(URI address) {
        return this.target(address != null ? address.toString() : null);
    }

    public JaxRsWebTarget target(String address) {
        return this.factory.newTarget(this.config, address);
    }

    public <T> T targetProxy(URI address, Class<T> clazz) {
        return this.targetProxy(address != null ? address.toString() : null, clazz);
    }

    public <T> T targetProxy(String address, Class<T> clazz) {
        return this.factory.newClient(this.config, address, clazz);
    }

    public JaxRsClientConfig getConfig() {
        return this.config;
    }

    public static Long getAccountId() {
        return accountId;
    }

    public static void setAccountId(Long accountId) {
        JaxRsClient.accountId = accountId;
    }

    public static Long getClientId() {
        return clientId;
    }

    public static void setClientId(Long clientId) {
        JaxRsClient.clientId = clientId;
    }

    public static Long getServerId() {
        return serverId;
    }

    public static void setServerId(Long serverId) {
        JaxRsClient.serverId = serverId;
    }

    public static final class JaxRsClientBuilder
    extends JaxRsClientConfig {
        private final JaxRsClientFactory factory;

        protected JaxRsClientBuilder(JaxRsClientFactory factory) {
            this.factory = factory;
        }

        private JaxRsClientBuilder withConfig(JaxRsClientConfig config) {
            this.copy(config);
            return this;
        }

        public JaxRsClientBuilder properties(Map<String, Object> src) {
            this.readProperties(src);
            return this;
        }

        public JaxRsClientBuilder asyncExecTimeout(long asyncExecuteTimeout) {
            this.setAsyncExecuteTimeout(asyncExecuteTimeout);
            return this;
        }

        public JaxRsClientBuilder asyncExecTimeoutRejection(boolean asyncExecuteTimeoutRejection) {
            this.setAsyncExecuteTimeoutRejection(asyncExecuteTimeoutRejection);
            return this;
        }

        public JaxRsClientBuilder followRedirects(boolean followRedirectsAutomatically) {
            this.setFollowRedirects(followRedirectsAutomatically);
            return this;
        }

        public JaxRsClientBuilder allowChunking(boolean chunkingAllowed) {
            this.setChunkingAllowed(chunkingAllowed);
            return this;
        }

        public JaxRsClientBuilder chunkingThreshold(int chunkingThreshold) {
            this.setChunkingThreshold(chunkingThreshold);
            return this;
        }

        public JaxRsClientBuilder chunkLength(int chunkLength) {
            this.setChunkLength(chunkLength);
            return this;
        }

        public JaxRsClientBuilder connectionTimeout(long connectionTimeoutInMillis) {
            this.setConnectionTimeout(connectionTimeoutInMillis);
            return this;
        }

        public JaxRsClientBuilder connectionType(JaxRsClientConstants.ConnectionType connectionType) {
            this.setConnectionType(connectionType);
            return this;
        }

        public JaxRsClientBuilder maxRetransmits(int maxRetransmits) {
            this.setMaxRetransmits(maxRetransmits);
            return this;
        }

        public JaxRsClientBuilder nonProxyHosts(String nonProxyHosts) {
            this.setNonProxyHosts(nonProxyHosts);
            return this;
        }

        public JaxRsClientBuilder proxyAddress(String proxyAddress) {
            this.setProxyAddress(proxyAddress);
            return this;
        }

        public JaxRsClientBuilder proxyAuthorizationType(String proxyAuthorizationType) {
            this.setProxyAuthorizationType(proxyAuthorizationType);
            return this;
        }

        public JaxRsClientBuilder proxyPassword(String proxyPassword) {
            this.setProxyPassword(proxyPassword);
            return this;
        }

        public JaxRsClientBuilder proxyType(JaxRsClientConstants.ProxyType proxyType) {
            this.setProxyType(proxyType);
            return this;
        }

        public JaxRsClientBuilder proxyUsername(String proxyUsername) {
            this.setProxyUsername(proxyUsername);
            return this;
        }

        public JaxRsClientBuilder receiveTimeout(long receiveTimeoutInMillis) {
            this.setReceiveTimeout(receiveTimeoutInMillis);
            return this;
        }

        public JaxRsClientBuilder authorizationType(String serverAuthorizationType) {
            this.setServerAuthorizationType(serverAuthorizationType);
            return this;
        }

        public JaxRsClientBuilder password(String serverPassword) {
            this.setServerPassword(serverPassword);
            return this;
        }

        public JaxRsClientBuilder username(String serverUsername) {
            this.setServerUsername(serverUsername);
            return this;
        }

        public JaxRsClientBuilder createThreadSafeProxyClients(boolean createThreadSafeClients) {
            this.setCreateThreadSafeProxyClients(createThreadSafeClients);
            return this;
        }

        public JaxRsClientBuilder proxyClientSubResourcesInheritHeaders(boolean inheritHeaders) {
            this.setProxyClientSubResourcesInheritHeaders(inheritHeaders);
            return this;
        }

        public JaxRsClientBuilder oAuthAuthorizeUri(String oauthAuthorizeUri) {
            this.setOAuthAuthorizeUri(oauthAuthorizeUri);
            return this;
        }

        public JaxRsClientBuilder oAuthTokenUri(String oauthTokenUri) {
            this.setOAuthTokenUri(oauthTokenUri);
            return this;
        }

        public JaxRsClientBuilder oAuthTokenValidationUri(String oauthTokenValidationUri) {
            this.setOAuthTokenValidationUri(oauthTokenValidationUri);
            return this;
        }

        public JaxRsClientBuilder oAuthClientId(String oauthClientId) {
            this.setOAuthClientId(oauthClientId);
            return this;
        }

        public JaxRsClientBuilder oAuthClientSecret(String oauthClientSecret) {
            this.setOAuthClientSecret(oauthClientSecret);
            return this;
        }

        public JaxRsClientBuilder oAuthRedirectUri(String oauthRedirectUri) {
            this.setOAuthRedirectUri(oauthRedirectUri);
            return this;
        }

        public JaxRsClientBuilder oAuthScopes(String oauthScopes) {
            this.setOAuthScopes(oauthScopes);
            return this;
        }

        public JaxRsClientBuilder oAuthSecretKeyAlgorithm(String oauthSecretKeyAlgorithm) {
            this.setOAuthSecretKeyAlgorithm(oauthSecretKeyAlgorithm);
            return this;
        }

        public JaxRsClientBuilder oAuthEncodedSecretKey(String oauthEncodedSecretKey) {
            this.setOAuthEncodedSecretKey(oauthEncodedSecretKey);
            return this;
        }

        public JaxRsClientBuilder oAuthFailOnRefreshTokenError(boolean oauthFailsOnRefreshTokenError) {
            this.setOAuthFailsOnRefreshTokenError(oauthFailsOnRefreshTokenError);
            return this;
        }

        public JaxRsClientBuilder oAuthTokenStore(JaxRsTokenStore oauthTokenStore) {
            this.setOAuthTokenStore(oauthTokenStore);
            return this;
        }

        public JaxRsClientBuilder oAuthConfirmHandler(JaxRsConfirmAccessHandler oauthTokenHandler) {
            this.setOAuthConfirmAccessHandler(oauthTokenHandler);
            return this;
        }

        public JaxRsClientBuilder oAuthCacheEnabled(boolean oauthCacheEnabled) {
            this.setOAuthCacheEnabled(oauthCacheEnabled);
            return this;
        }

        public JaxRsClientBuilder oAuthCacheMaxSize(int oauthCacheMaxSize) {
            this.setOAuthCacheMaxSize(oauthCacheMaxSize);
            return this;
        }

        public JaxRsClientBuilder oAuthCacheEvictTimeoutMillis(long oauthCacheEvictTimeoutMillis) {
            this.setOAuthCacheEvictTimeoutMillis(oauthCacheEvictTimeoutMillis);
            return this;
        }

        public JaxRsClient build() {
            return new JaxRsClient(this.factory, this.copy());
        }
    }

    public static interface JaxRsClientFactory {
        public <T> T newClient(JaxRsClientConfig var1, String var2, Class<T> var3);

        public JaxRsWebTarget newTarget(JaxRsClientConfig var1, String var2);
    }
}

