/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.endpoints;

import java.io.InputStream;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.ContentDisposition;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.security.SecurityContext;
import org.eclipse.osee.framework.jdk.core.type.OseePrincipal;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.OAuthUtil;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.endpoints.AbstractClientService;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.endpoints.ClientFormData;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.endpoints.ClientRegistrationData;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.endpoints.ClientRegistrationResponse;
import org.eclipse.osee.logger.Log;

@Path(value="/client-registration")
public class ClientRegistrationEndpoint
extends AbstractClientService {
    public ClientRegistrationEndpoint(Log logger) {
        super(logger);
    }

    @GET
    @Produces(value={"text/html", "application/xml", "application/json"})
    public Response startRegistration(@Context UriInfo uriInfo, @Context HttpHeaders headers) {
        SecurityContext sc = this.getAndValidateSecurityContext();
        UserSubject subject = this.createUserSubject(sc);
        ClientRegistrationData data = new ClientRegistrationData();
        this.addAuthenticityTokenToSession(data, (MultivaluedMap<String, String>)headers.getRequestHeaders(), subject);
        this.personalizeData(data, subject);
        String replyTo = UriBuilder.fromPath((String)uriInfo.getPath()).path("complete").build(new Object[0]).toString();
        data.setClientGuid(GUID.create());
        data.setReplyTo(replyTo);
        return Response.ok((Object)data).build();
    }

    @POST
    @Path(value="/complete")
    @Consumes(value={"multipart/form-data"})
    public Response finishRegistration(@Context UriInfo uriInfo, MultipartBody multiPart) {
        SecurityContext securityContext = this.getAndValidateSecurityContext();
        UserSubject userSubject = this.createUserSubject(securityContext);
        String sessionToken = (String)multiPart.getAttachmentObject("session_authenticity_token", String.class);
        if (!this.compareRequestAndSessionTokens(sessionToken, userSubject)) {
            throw ExceptionUtils.toBadRequestException(null, null);
        }
        String decision = (String)multiPart.getAttachmentObject("applicationRegistrationDecision", String.class);
        boolean registrationAllowed = "register".equals(decision);
        Response response = null;
        response = registrationAllowed ? this.register(uriInfo, userSubject, multiPart) : this.createCancellationResponse(multiPart);
        return response;
    }

    private Response register(UriInfo uriInfo, UserSubject userSubject, MultipartBody multiPart) {
        String appGuid = (String)multiPart.getAttachmentObject("applicationGuid", String.class);
        String appName = (String)multiPart.getAttachmentObject("applicationName", String.class);
        String appDesc = (String)multiPart.getAttachmentObject("applicationDescription", String.class);
        String appWebsite = (String)multiPart.getAttachmentObject("applicationUri", String.class);
        String appRedirects = (String)multiPart.getAttachmentObject("applicationRedirectUri", String.class);
        String appConfidential = (String)multiPart.getAttachmentObject("applicationConfidential", String.class);
        String appAudiences = (String)multiPart.getAttachmentObject("applicationAllowedAudiences", String.class);
        String appGrantTypes = (String)multiPart.getAttachmentObject("applicationAllowedGrantTypes", String.class);
        String appScopes = (String)multiPart.getAttachmentObject("applicationAllowedScopes", String.class);
        String appCertificate = (String)multiPart.getAttachmentObject("applicationCertificate", String.class);
        String appLogoUri = (String)multiPart.getAttachmentObject("applicationLogoUri", String.class);
        ClientFormData input = new ClientFormData(appGuid);
        input.setUserSubject(userSubject);
        input.setName(appName);
        input.setDescription(appDesc);
        input.setWebUri(appWebsite);
        input.setRedirectUris(this.parseMultilined(appRedirects));
        input.setConfidential(this.parseConfidential(appConfidential));
        input.setAllowedAudiences(this.parseMultilined(appAudiences));
        input.setAllowedGrantTypes(this.parseMultilined(appGrantTypes));
        input.setAllowedScopes(this.parseMultilined(appScopes));
        input.setCertificates(this.parseMultilined(appCertificate));
        input.setLogoUri(appLogoUri);
        Attachment att = multiPart.getAttachment("applicationLogoData");
        if (att != null) {
            InputStream logoContent = (InputStream)att.getObject(InputStream.class);
            input.setLogoContent(logoContent);
            ContentDisposition cd = att.getContentDisposition();
            if (cd != null) {
                input.setLogoParameters(cd.getParameters());
            }
        }
        OseePrincipal principal = OAuthUtil.newOseePrincipal(userSubject);
        Client client = this.getDataProvider().createClient(uriInfo, principal, input);
        ClientRegistrationResponse data = new ClientRegistrationResponse();
        data.setClientId(client.getClientId());
        data.setClientSecret(client.getClientSecret());
        return Response.ok((Object)data).build();
    }

    private Response createCancellationResponse(MultipartBody body) {
        return Response.ok().build();
    }

    private boolean parseConfidential(String appConfidential) {
        return true;
    }

    private List<String> parseMultilined(String rawData) {
        return Collections.fromString((String)rawData, (String)"\\s+");
    }
}

